/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.executors.ExecutorFactory;
import org.apache.servicemix.executors.impl.ExecutorFactoryImpl;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.EndpointRegistry;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Reference;
import org.apache.servicemix.nmr.api.ServiceMixException;
import org.apache.servicemix.nmr.api.Wire;
import org.apache.servicemix.nmr.api.event.EndpointListener;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.api.service.ServiceRegistry;
import org.apache.servicemix.nmr.core.CacheableReference;
import org.apache.servicemix.nmr.core.ChannelImpl;
import org.apache.servicemix.nmr.core.FilterMatchingReference;
import org.apache.servicemix.nmr.core.InternalEndpointWrapper;
import org.apache.servicemix.nmr.core.PropertyMatchingReference;
import org.apache.servicemix.nmr.core.ServiceRegistryImpl;
import org.osgi.framework.InvalidSyntaxException;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointRegistryImpl
implements EndpointRegistry {
    public static final String EXECUTOR_PREFIX = "nmr.endpoint.";
    public static final String EXECUTOR_DEFAULT = "default";
    private NMR nmr;
    private ConcurrentMap<Endpoint, InternalEndpoint> endpoints = new ConcurrentHashMap<Endpoint, InternalEndpoint>();
    private Map<InternalEndpoint, Endpoint> wrappers = new ConcurrentHashMap<InternalEndpoint, Endpoint>();
    private Map<CacheableReference, Boolean> references = new WeakHashMap<CacheableReference, Boolean>();
    private ServiceRegistry<InternalEndpoint> registry;
    private ExecutorFactory executorFactory;

    public EndpointRegistryImpl() {
    }

    public EndpointRegistryImpl(NMR nmr) {
        this.nmr = nmr;
    }

    public NMR getNmr() {
        return this.nmr;
    }

    public void setNmr(NMR nmr) {
        this.nmr = nmr;
    }

    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    public void setExecutorFactory(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    public ServiceRegistry<InternalEndpoint> getRegistry() {
        return this.registry;
    }

    public void setRegistry(ServiceRegistry<InternalEndpoint> registry) {
        this.registry = registry;
    }

    public void init() {
        if (this.nmr == null) {
            throw new NullPointerException("nmr must be not null");
        }
        if (this.registry == null) {
            this.registry = new ServiceRegistryImpl<InternalEndpoint>();
        }
        if (this.executorFactory == null) {
            this.executorFactory = new ExecutorFactoryImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Endpoint endpoint, Map<String, ?> properties) {
        InternalEndpointWrapper wrapper = new InternalEndpointWrapper(endpoint, properties);
        if (this.endpoints.putIfAbsent(endpoint, wrapper) == null) {
            String name = (String)properties.get("NAME");
            if (name == null || name.length() == 0) {
                name = EXECUTOR_DEFAULT;
            }
            name = EXECUTOR_PREFIX + name;
            Executor executor = this.executorFactory.createExecutor(name);
            ChannelImpl channel = new ChannelImpl(wrapper, executor, this.nmr);
            wrapper.setChannel((Channel)channel);
            this.wrappers.put(wrapper, endpoint);
            this.registry.register((Object)wrapper, properties);
            for (EndpointListener listener : this.nmr.getListenerRegistry().getListeners(EndpointListener.class)) {
                listener.endpointRegistered((InternalEndpoint)wrapper);
            }
            Map<CacheableReference, Boolean> map = this.references;
            synchronized (map) {
                for (CacheableReference ref : this.references.keySet()) {
                    ref.setDirty();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Endpoint endpoint, Map<String, ?> properties) {
        InternalEndpoint wrapper;
        if (endpoint instanceof InternalEndpoint) {
            wrapper = (InternalEndpoint)endpoint;
            if (wrapper != null && (endpoint = this.wrappers.remove(wrapper)) != null) {
                this.endpoints.remove(endpoint);
            }
        } else {
            wrapper = (InternalEndpoint)this.endpoints.remove(endpoint);
            if (wrapper != null) {
                this.wrappers.remove(wrapper);
            }
        }
        if (wrapper != null) {
            wrapper.getChannel().close();
            this.registry.unregister((Object)wrapper, properties);
            for (EndpointListener listener : this.nmr.getListenerRegistry().getListeners(EndpointListener.class)) {
                listener.endpointUnregistered(wrapper);
            }
        }
        Map<CacheableReference, Boolean> map = this.references;
        synchronized (map) {
            for (CacheableReference ref : this.references.keySet()) {
                ref.setDirty();
            }
        }
    }

    public Set<Endpoint> getServices() {
        return this.registry.getServices();
    }

    public Map<String, ?> getProperties(Endpoint endpoint) {
        InternalEndpoint wrapper = endpoint instanceof InternalEndpoint ? (InternalEndpoint)endpoint : (InternalEndpoint)this.endpoints.get(endpoint);
        return this.registry.getProperties((Object)wrapper);
    }

    public List<Endpoint> query(Map<String, ?> properties) {
        return this.internalQuery(this.handleWiring(properties));
    }

    protected Map<String, ?> handleWiring(Map<String, ?> properties) {
        Wire wire = this.nmr.getWireRegistry().getWire(properties);
        if (wire == null) {
            return properties;
        }
        return wire.getTo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference lookup(Map<String, ?> props) {
        Map<String, ?> properties = this.handleWiring(props);
        PropertyMatchingReference ref = new PropertyMatchingReference(properties);
        Map<CacheableReference, Boolean> map = this.references;
        synchronized (map) {
            this.references.put(ref, true);
        }
        return ref;
    }

    public synchronized Reference lookup(Document xml) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference lookup(String filter) {
        try {
            try {
                FilterMatchingReference ref = new FilterMatchingReference(filter);
                Map<CacheableReference, Boolean> map = this.references;
                synchronized (map) {
                    this.references.put(ref, true);
                }
                return ref;
            }
            catch (InvalidSyntaxException e) {
                throw new ServiceMixException("Invalid filter syntax: " + e.getMessage());
            }
        }
        catch (NoClassDefFoundError e) {
            throw new UnsupportedOperationException(e);
        }
    }

    protected List<InternalEndpoint> internalQuery(Map<String, ?> properties) {
        ArrayList<InternalEndpoint> endpoints = new ArrayList<InternalEndpoint>();
        if (properties == null) {
            endpoints.addAll(this.registry.getServices());
        } else {
            for (InternalEndpoint e : this.registry.getServices()) {
                Map epProps = this.registry.getProperties((Object)e);
                boolean match = true;
                for (String name : properties.keySet()) {
                    if (properties.get(name).equals(epProps.get(name))) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                endpoints.add(e);
            }
        }
        return endpoints;
    }
}

