/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.jaxp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class DOMStreamReader
implements XMLStreamReader {
    protected Map properties = new HashMap();
    protected int currentEvent = 7;
    protected FastStack<ElementFrame> frames = new FastStack();
    protected ElementFrame frame;

    public DOMStreamReader(ElementFrame frame) {
        this.init(frame);
    }

    private void init(ElementFrame f) {
        this.frame = f;
        this.frames.push(this.frame);
        this.newFrame(f);
    }

    protected ElementFrame getCurrentFrame() {
        return this.frame;
    }

    public Object getProperty(String key) throws IllegalArgumentException {
        return this.properties.get(key);
    }

    public int next() throws XMLStreamException {
        if (this.frame.ended) {
            this.frames.pop();
            if (!this.frames.empty()) {
                this.frame = this.frames.peek();
            } else {
                this.currentEvent = 8;
                return this.currentEvent;
            }
        }
        if (!this.frame.started) {
            this.frame.started = true;
            this.currentEvent = 1;
        } else if (this.frame.currentAttribute < this.getAttributeCount() - 1) {
            ++this.frame.currentAttribute;
            this.currentEvent = 10;
        } else if (this.frame.currentChild < this.getChildCount() - 1) {
            ++this.frame.currentChild;
            this.currentEvent = this.moveToChild(this.frame.currentChild);
            if (this.currentEvent == 1) {
                ElementFrame newFrame = this.getChildFrame(this.frame.currentChild);
                newFrame.started = true;
                this.frame = newFrame;
                this.frames.push(this.frame);
                this.currentEvent = 1;
                this.newFrame(newFrame);
            }
        } else {
            this.frame.ended = true;
            this.currentEvent = 2;
            this.endElement();
        }
        return this.currentEvent;
    }

    protected void newFrame(ElementFrame newFrame) {
    }

    protected void endElement() {
    }

    protected abstract int moveToChild(int var1);

    protected abstract ElementFrame getChildFrame(int var1);

    protected abstract int getChildCount();

    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public abstract String getElementText() throws XMLStreamException;

    public int nextTag() throws XMLStreamException {
        while (this.hasNext()) {
            if (1 != this.next()) continue;
            return 1;
        }
        return this.currentEvent;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.frames.size() != 0 || !this.frame.ended;
    }

    public void close() throws XMLStreamException {
    }

    public abstract String getNamespaceURI(String var1);

    public boolean isStartElement() {
        return this.currentEvent == 1;
    }

    public boolean isEndElement() {
        return this.currentEvent == 2;
    }

    public boolean isCharacters() {
        return this.currentEvent == 4;
    }

    public boolean isWhiteSpace() {
        return this.currentEvent == 6;
    }

    public int getEventType() {
        return this.currentEvent;
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        char[] src = this.getText().toCharArray();
        if (sourceStart + length >= src.length) {
            length = src.length - sourceStart;
        }
        for (int i = 0; i < length; ++i) {
            target[targetStart + i] = src[i + sourceStart];
        }
        return length;
    }

    public boolean hasText() {
        return this.currentEvent == 4 || this.currentEvent == 11 || this.currentEvent == 9 || this.currentEvent == 5 || this.currentEvent == 6;
    }

    public Location getLocation() {
        return new Location(){

            public int getCharacterOffset() {
                return 0;
            }

            public int getColumnNumber() {
                return 0;
            }

            public int getLineNumber() {
                return 0;
            }

            public String getPublicId() {
                return null;
            }

            public String getSystemId() {
                return null;
            }
        };
    }

    public boolean hasName() {
        return this.currentEvent == 1 || this.currentEvent == 2;
    }

    public String getVersion() {
        return null;
    }

    public boolean isStandalone() {
        return false;
    }

    public boolean standaloneSet() {
        return false;
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public static class ElementFrame {
        Object element;
        boolean started;
        boolean ended;
        int currentChild = -1;
        int currentAttribute = -1;
        int currentElement = -1;
        List<String> uris;
        List<String> prefixes;
        List attributes;
        final ElementFrame parent;

        public ElementFrame(Object element, ElementFrame parent) {
            this.element = element;
            this.parent = parent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FastStack<T>
    extends ArrayList<T> {
        public void push(T o) {
            this.add(o);
        }

        public T pop() {
            return (T)this.remove(this.size() - 1);
        }

        public boolean empty() {
            return this.size() == 0;
        }

        public T peek() {
            return (T)this.get(this.size() - 1);
        }
    }
}

