/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.jaxp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathFactory;

public class DefaultNamespaceContext
implements NamespaceContext {
    private final Map map;
    private final NamespaceContext parent;

    public DefaultNamespaceContext() {
        this.map = new HashMap();
        XPathFactory factory = XPathFactory.newInstance();
        this.parent = factory.newXPath().getNamespaceContext();
    }

    public DefaultNamespaceContext(NamespaceContext parent, Map map) {
        this.parent = parent;
        this.map = map;
    }

    public DefaultNamespaceContext add(String prefix, String uri) {
        this.map.put(prefix, uri);
        return this;
    }

    public String getNamespaceURI(String prefix) {
        String answer = (String)this.map.get(prefix);
        if (answer == null && this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        return answer;
    }

    public String getPrefix(String namespaceURI) {
        for (Map.Entry entry : this.map.entrySet()) {
            if (!namespaceURI.equals(entry.getValue())) continue;
            return (String)entry.getKey();
        }
        if (this.parent != null) {
            return this.parent.getPrefix(namespaceURI);
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        HashSet<Object> set = new HashSet<Object>();
        for (Map.Entry entry : this.map.entrySet()) {
            if (!namespaceURI.equals(entry.getValue())) continue;
            set.add(entry.getKey());
        }
        if (this.parent != null) {
            Iterator<Object> iter = this.parent.getPrefixes(namespaceURI);
            while (iter.hasNext()) {
                set.add(iter.next());
            }
        }
        return set.iterator();
    }
}

