/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.util.xml;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.swordfish.internal.core.util.xml.StringSource;
import org.springframework.util.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class XmlUtil {
    public static final String DEFAULT_CHARSET_PROPERTY = "org.apache.servicemix.default.charset";
    public static final String defaultCharset = System.getProperty("org.apache.servicemix.default.charset", "UTF-8");
    private static TransformerFactory transformerFactory;
    private static DocumentBuilderFactory builderFactory;

    public static Transformer getTransformer() {
        Transformer ret;
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        Assert.notNull((Object)transformerFactory);
        try {
            ret = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        Assert.notNull((Object)ret);
        ret.setOutputProperty("encoding", defaultCharset);
        return ret;
    }

    public static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder builder = null;
        if (builderFactory == null) {
            builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
        }
        try {
            builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Assert.notNull((Object)builder);
        return builder;
    }

    public static DocumentFragment wrapWithDocumentFragment(String xml) {
        if (xml == null) {
            return null;
        }
        Node node = XmlUtil.toDOMFromString(xml);
        return XmlUtil.wrapWithDocumentFragment(node.getFirstChild());
    }

    public static DocumentFragment wrapWithDocumentFragment(Node node) {
        DocumentFragment fragment = null;
        if (node != null) {
            Document doc = XmlUtil.getDocumentBuilder().newDocument();
            fragment = doc.createDocumentFragment();
            Node cloneNode = doc.importNode(node, true);
            fragment.appendChild(cloneNode);
        }
        return fragment;
    }

    public static Node toDOMFromSource(Source source) {
        if (source == null) {
            return null;
        }
        DOMResult result = new DOMResult();
        try {
            XmlUtil.getTransformer().transform(source, result);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
        return result.getNode();
    }

    public static Node toDOMFromString(String xml) {
        if (xml == null) {
            return null;
        }
        return XmlUtil.toDOMFromSource(new StringSource(xml));
    }

    public static String toStringFromDOM(Node node) {
        if (node == null) {
            return null;
        }
        DOMSource source = new DOMSource(node);
        StringWriter buffer = new StringWriter();
        try {
            XmlUtil.getTransformer().transform(source, new StreamResult(buffer));
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
        return buffer.toString();
    }

    public static String toStringFromSource(Source source) {
        if (source == null) {
            return null;
        }
        if (source instanceof StringSource) {
            return ((StringSource)source).getText();
        }
        StringWriter buffer = new StringWriter();
        try {
            XmlUtil.getTransformer().transform(source, new StreamResult(buffer));
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
        return buffer.toString();
    }
}

