/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.tooling.ode.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelSupport {
    public static List<PartnerLinkInfo> retrievePartnerLinksFromDeployXml(File deployXml) {
        Assert.isNotNull((Object)deployXml);
        Assert.isTrue((boolean)deployXml.exists());
        ArrayList<PartnerLinkInfo> ret = new ArrayList<PartnerLinkInfo>();
        FileInputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(deployXml);
                Document document = DOMUtils.readXml((InputStream)inputStream);
                BpelSupport.retrievePartnerLinks(document.getFirstChild(), ret);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException ioEx) {
                    throw new IllegalStateException(ioEx.getMessage(), ioEx);
                }
            }
        }
        return ret;
    }

    private static void retrievePartnerLinks(Node element, List<PartnerLinkInfo> ret) {
        if ("service".equalsIgnoreCase(element.getLocalName())) {
            PartnerLinkInfo partnerLinkInfo = new PartnerLinkInfo();
            partnerLinkInfo.portName = DOMUtils.getAttribute((Node)element, (String)"port");
            String serviceQname = DOMUtils.getAttribute((Node)element, (String)"name");
            if (serviceQname.contains(":")) {
                String[] str = serviceQname.split(":");
                String nameSpace = DOMUtils.getNamespace((Element)((Element)element), (String)str[0]);
                if (nameSpace != null) {
                    partnerLinkInfo.serviceName = new QName(nameSpace, str[1], str[0]);
                }
            } else {
                throw new IllegalStateException("serviceQname(" + serviceQname + ") doesn't contain ' to separate namespace and localpart");
            }
            if (element.getParentNode().getLocalName().equalsIgnoreCase("provide")) {
                partnerLinkInfo.isProvider = false;
            } else if (element.getParentNode().getLocalName().equalsIgnoreCase("invoke")) {
                partnerLinkInfo.isProvider = true;
            } else {
                throw new IllegalStateException("Unexpected element in deploy.xml - " + element.getParentNode().getLocalName());
            }
            ret.add(partnerLinkInfo);
        } else {
            NodeList nodeList = element.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                BpelSupport.retrievePartnerLinks(nodeList.item(i), ret);
                ++i;
            }
        }
    }

    public static List<String> retriveWsdlLocationsFromBpelFile(File bpelFile) {
        Assert.isNotNull((Object)bpelFile);
        Assert.isTrue((boolean)bpelFile.exists());
        FileInputStream inputStream = null;
        ArrayList<String> ret = new ArrayList<String>();
        try {
            inputStream = new FileInputStream(bpelFile);
            Document bpelDocument = DOMUtils.readXml((InputStream)inputStream);
            List elementList = DOMUtils.findAllElementsByTagNameNS((Element)bpelDocument.getDocumentElement(), (String)"http://docs.oasis-open.org/wsbpel/2.0/process/executable", (String)"import");
            for (Element wsdlImport : elementList) {
                String location = wsdlImport.getAttribute("location");
                if (location == null) continue;
                ret.add(location);
            }
        }
        catch (Exception exception) {}
        return ret;
    }

    public static class PartnerLinkInfo {
        public boolean isProvider;
        public String portName;
        public QName serviceName;

        public String toString() {
            return String.valueOf(this.isProvider) + this.portName + this.serviceName;
        }
    }
}

