/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.tooling.server.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.wst.server.core.IModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2Helper {
    private Map<WorkspaceFeatureModel, String> iuIdMap;
    private Map<WorkspaceFeatureModel, String> iuVersionMap;
    private Map<WorkspaceFeatureModel, Integer> deltaKindMap;
    private Map<WorkspaceFeatureModel, Integer> kindMap;
    private Map<Integer, List<WorkspaceFeatureModel>> wfModels;

    public List<WorkspaceFeatureModel> getWfModels(int deltaKind) {
        return this.wfModels.get(deltaKind);
    }

    public void addModule(IModule module, int kind, int deltaKind) {
        if (this.wfModels == null) {
            this.wfModels = new HashMap<Integer, List<WorkspaceFeatureModel>>();
            this.iuIdMap = new HashMap<WorkspaceFeatureModel, String>();
            this.iuVersionMap = new HashMap<WorkspaceFeatureModel, String>();
            this.kindMap = new HashMap<WorkspaceFeatureModel, Integer>();
            this.deltaKindMap = new HashMap<WorkspaceFeatureModel, Integer>();
        }
        if (!this.wfModels.containsKey(deltaKind)) {
            this.wfModels.put(deltaKind, new ArrayList());
        }
        List<WorkspaceFeatureModel> models = this.wfModels.get(deltaKind);
        IFile featureFile = (IFile)module.getProject().findMember("feature.xml");
        WorkspaceFeatureModel wfModel = new WorkspaceFeatureModel(featureFile);
        wfModel.load();
        models.add(wfModel);
        IFeature feature = wfModel.getFeature();
        this.kindMap.put(wfModel, kind);
        this.deltaKindMap.put(wfModel, deltaKind);
        this.iuIdMap.put(wfModel, String.valueOf(module.getName()) + ".feature.group");
        this.iuVersionMap.put(wfModel, feature.getVersion());
    }

    public String getIuIds(int deltaKind) {
        StringBuilder builder = new StringBuilder();
        for (WorkspaceFeatureModel wfModel : this.wfModels.get(deltaKind)) {
            builder.append(this.iuIdMap.get(wfModel));
            builder.append(',');
        }
        String result = builder.toString();
        return result.length() > 0 ? result.substring(0, result.length() - 1) : result;
    }

    public void setFeatureModels(Map<Integer, List<IModule>> moduleMap, int kind) {
        for (int deltaKind : moduleMap.keySet()) {
            List<IModule> modules = moduleMap.get(deltaKind);
            for (IModule module : modules) {
                this.addModule(module, kind, deltaKind);
            }
        }
    }

    public boolean hasNonDeleteOperation() {
        if (this.wfModels == null) {
            return false;
        }
        for (int deltaKind : this.wfModels.keySet()) {
            if (deltaKind == 3) continue;
            return true;
        }
        return false;
    }

    public List<WorkspaceFeatureModel> getDeployableModels() {
        ArrayList<WorkspaceFeatureModel> models = new ArrayList<WorkspaceFeatureModel>();
        if (this.wfModels != null) {
            for (int deltaKind : this.wfModels.keySet()) {
                if (deltaKind == 3) continue;
                models.addAll((Collection<WorkspaceFeatureModel>)this.wfModels.get(deltaKind));
            }
        }
        return models;
    }

    public static void addFolder(File folder, ZipOutputStream zos, String path) throws IOException {
        String[] fileList;
        String[] stringArray = fileList = folder.list();
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            String relativePath = path.length() == 0 ? fileName : String.valueOf(path) + File.separator + fileName;
            File file = new File(folder, fileName);
            if (file.isDirectory()) {
                P2Helper.addFolder(file, zos, relativePath);
            } else {
                int len;
                ZipEntry entry = new ZipEntry(relativePath);
                zos.putNextEntry(entry);
                FileInputStream fis = new FileInputStream(file);
                byte[] buf = new byte[2048];
                while ((len = fis.read(buf)) > 0) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                fis.close();
            }
            ++n2;
        }
    }
}

