/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.tooling.server.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwordfishClient {
    private HttpClient httpClient = new HttpClient();
    private String hostname;
    private String pathname;
    private HttpMethodRetryHandler retryhandler = new HttpMethodRetryHandler(){

        public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
            return false;
        }
    };

    public SwordfishClient(String hostname, String pathname) {
        this.hostname = hostname;
        this.pathname = pathname;
    }

    public int call(Map<String, String> parameters, InputStream stream, OutputStream error) throws HttpException, IOException {
        int statusCode;
        String uri = String.valueOf(this.hostname) + this.pathname;
        PutMethod putMethod = new PutMethod(uri);
        putMethod.getParams().setParameter("http.method.retry-handler", (Object)this.retryhandler);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (entry.getValue() == null) continue;
            putMethod.setRequestHeader(new Header(entry.getKey(), entry.getValue()));
        }
        if (stream != null) {
            InputStreamRequestEntity entity = new InputStreamRequestEntity(stream);
            putMethod.setRequestEntity((RequestEntity)entity);
        }
        if ((statusCode = this.httpClient.executeMethod((HttpMethod)putMethod)) != 200) {
            error.write(putMethod.getStatusText().getBytes());
        }
        return statusCode;
    }
}

