/*******************************************************************************
 * Copyright (c) 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.helper;

/**
 * A view on a wsdl that exposes the data relevant for code generation.
 * Will deliver the information for the first soap/soap12 port of the 
 * first service found (in a WSDL)
 */
public interface ServiceModel {
	/**
	 * @return the namespace string
	 */
	String getTargetNamespace();
	
	/**
	 * @return the fully qualified implementor class
	 */
	String getImplementorClass();
	
	/**
	 * @return the service name (local)
	 */
	String getServiceName();
	
	/**
	 * @return the service url
	 */
	String getServiceUrl();
	
	/**
	 * @return the name of the port type connected to the service url
	 */
	String getSoapPortType();
}
