/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.ui.templates.ITemplateSection;

/**
 * class PluginContentWsdlWizard
 * 
 * @author amarkevich
 */
public class PluginContentWsdlWizard extends PluginContentWizard {
	private PluginContentWsdlWizardSection wizardSection;
	
	private static final IPluginReference[] DEPENDENCIES = {
		//new PluginReference("javax.xml.bind", null, 0),
	};

	private static final String[] IMPORT_PACKAGES = {
		"javax.xml.bind",
		"javax.xml.bind.annotation",
		"javax.jws.soap",
	};
	
	@Override
	public ITemplateSection[] createTemplateSections() {
		wizardSection = new PluginContentWsdlWizardSection();
        return new ITemplateSection[] { wizardSection };
	}

	@Override
	public IPluginReference[] getDependencies(String schemaVersion) {
		List<IPluginReference> pluginReferences = new ArrayList<IPluginReference>(Arrays.asList(super.getDependencies(schemaVersion)));
		pluginReferences.addAll(Arrays.asList(DEPENDENCIES));
		return pluginReferences.toArray(new IPluginReference[pluginReferences.size()]);
	}

	@Override
	public String[] getImportPackages() {
		Set<String> pluginImportPackages = new LinkedHashSet<String>(Arrays.asList(super.getImportPackages()));
		pluginImportPackages.addAll(Arrays.asList(IMPORT_PACKAGES));

		if (isProviderGenerationFromWsdl()) {
			addConsumerImports(pluginImportPackages);
		}
		return pluginImportPackages.toArray(new String[pluginImportPackages.size()]);
	}
	
	private final boolean isProviderGenerationFromWsdl() {
		return (wizardSection != null);
	}
	
	/**
	 * Add the packages exported by the used consumer projects to the import packages
	 * @param existingImportPackages - a list of currently imported packages
	 */
	private void addConsumerImports(Set<String> existingImportPackages) {
		List<ManifestElement> consumerImports = wizardSection.getConsumerImports();
		
		if (consumerImports != null) {
			for (ManifestElement me : consumerImports) {
				existingImportPackages.add(me.toString());
			}
		}
	}
}
