/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;

import javax.xml.namespace.QName;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.swordfish.registry.tooling.Activator;
import org.eclipse.swordfish.registry.tooling.preferences.PreferenceConstants;
import org.eclipse.swordfish.tooling.ui.Messages;
import org.eclipse.swordfish.tooling.ui.helper.DialogSupport;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

/**
 * class PluginContentWsdlWizardPage
 * 
 * @author yyurkin
 */
@SuppressWarnings("restriction")
public class PluginContentWsdlWizardPage extends WizardPage {

	private static final String WSDL = "wsdl";
	private static final int WIDTH_EDIT_FIELD = 397;
	private static final int WIDTH_TREE = 500;
	private static final int HEIGTH_TREE = 200;
	private static final String WORKSPACE = "Workspace";
	private static final String FILESYSTEM = "File system";
	private static final String PATH_TO_WSDL = "Path:";
	private static final String BROWSE_SF = "Browse...";
	private static final String SERVICE_REGISTRY = "Service Registry";
	private static final String URL_TO_WSDL = "URL:";
	private static final String BROWSE_SR = "Browse...";
	private static final String WSDL_LOCATION = "WSDL location";
	private static final String PROVIDER_ENDPOINT = "Provider endpoint";
	private static final String STATIC_ENDPOINT = "Generate static endpoint";
	private static final String DYNAMIC_ENDPOINT = "Use dynamic endpoint lookup";
	private static final String GENERATE_EXAMPLE_CODE = "Generate example consumer code";
	private static final int EXAMPLE_CODE_MARGIN_WIDTH = 2;
	private static final int EXAMPLE_CODE_MARGIN_HEIGHT = 11;
	private static final String MESSAGE_SR_UNAVAILABLE = "The Service Registry is unavailable. Please check the URL in Preferences->Swordfish->Registry and make sure that the Service Registry is running.";
	private static final String MESSAGE_SR_IS_EMPTY = "The Service Registry does not contain any entries.";
	private static final String CONSUMER = "Consumer";
	private static final String IMPORT_FILE_NAME = "importwsdl";
	private static final String DOT = ".";

	protected final int bidWorkspace = 1;
	protected final int bidFileSystem = 2;
	protected final int bidServiceRegistry = 3;

	protected final int bidStaticEndpoint = 5;
	protected final int bidDynamicLookup = 6;

	private Text nameField;
	private Text nameFSField;
	private Label nameLabel;
	private Label nameFSLabel;
	private Button serviceRegisrtyButton;
	private Button fileSystemButton;
	private URL currentListURL;
	private String currentListQName = "";
	private String currentTempFileContent = "";
	private File tempFile;
	private int bidSelected = 1;
	private int bidEndpointSelected = 5;
	private String tempWSDLPath = "";
	private Button doGenerateExampleCode;
	private Group wsdlLocationGroup;
	private Composite fWorkspaceComposite = null;
	private Composite fFileSystemComposite = null;
	private Composite fServiceRegistryComposite = null;
	private IResource selectedResource;
	private TreeViewer treeViewer;
	private DrillDownComposite drillDown;

	/** link to next page, using only for CompositeServicePage for a moment */
	private IWizardPage nextPage;

	/**
	 * The constructor from superclass.
	 */
	protected PluginContentWsdlWizardPage() {
		super(Messages.UI_TITLE_JAVA_PROJECT_FROM_WSDL);
		setTitle(Messages.UI_TITLE_JAVA_PROJECT_FROM_WSDL);
		setDescription(Messages.UI_DESCRIPTION_JAVA_PROJECT_FROM_WSDL);
	}

	public void setNextPage(IWizardPage nextPage) {
		this.nextPage = nextPage;
	}

	public IWizardPage getNextPage() {
		if (nextPage != null) {
			return nextPage;
		}
		return super.getNextPage();
	}

	public void setPageComplete(boolean complete) {
		if (complete && nextPage != null) {
			ServiceWsdlWizard wizard = (ServiceWsdlWizard) this.getWizard();
			wizard.addPage(nextPage);
		}
		super.setPageComplete(complete);

	}

	/**
	 * {@inheritDoc}
	 */
	public void createControl(final Composite parent) {
		try {
			tempFile = File.createTempFile(IMPORT_FILE_NAME, DOT + WSDL);
		} catch (IOException e2) {
			tempFile = null;
		}
		initializeDialogUnits(parent);

		Composite control = new Composite(parent, SWT.NONE);
		GridLayout controlLayout = new GridLayout(1, true);
		GridData controlData = new GridData();
		controlData.horizontalAlignment = SWT.FILL;
		control.setLayout(controlLayout);
		control.setLayoutData(controlData);

		wsdlLocationGroup = new Group(control, SWT.NONE);
		GridLayout layout = new GridLayout(1, true);
		GridData data = new GridData();
		wsdlLocationGroup.setLayout(layout);
		wsdlLocationGroup.setLayoutData(data);
		wsdlLocationGroup.setText(WSDL_LOCATION);
		createRadioButton(wsdlLocationGroup, WORKSPACE, bidWorkspace, true);
		fWorkspaceComposite = new Composite(wsdlLocationGroup, SWT.NONE);
		fWorkspaceComposite.setLayout(new GridLayout(3, false));
		drillDown = new DrillDownComposite(fWorkspaceComposite, SWT.BORDER);
		GridData spec = new GridData(GridData.VERTICAL_ALIGN_FILL
				| GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL
				| GridData.GRAB_VERTICAL);
		spec.widthHint = WIDTH_TREE;
		spec.heightHint = HEIGTH_TREE;
		drillDown.setLayoutData(spec);

		treeViewer = new TreeViewer(drillDown, SWT.NONE);
		drillDown.setChildTree(treeViewer);
		treeViewer.setContentProvider(new WorkbenchContentProvider());
		treeViewer.setLabelProvider(new WorkbenchLabelProvider());
		treeViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection = (IStructuredSelection) event
						.getSelection();
				selectedResource = (IResource) selection.getFirstElement();
				setPageComplete(validatePage());
			}
		});
		treeViewer.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				ISelection selection = event.getSelection();
				if (selection instanceof IStructuredSelection) {
					Object item = ((IStructuredSelection) selection)
							.getFirstElement();
					if (treeViewer.getExpandedState(item)) {
						treeViewer.collapseToLevel(item, 1);
					} else {
						treeViewer.expandToLevel(item, 1);
					}
				}
			}
		});
		WSDLFilter viewerFileFilter = new WSDLFilter();
		if (viewerFileFilter != null) {
			treeViewer.addFilter(viewerFileFilter);
		}
		treeViewer.setInput(ResourcesPlugin.getWorkspace());
		treeViewer.setSelection(getInitialSelection(), true);

		fWorkspaceComposite.setEnabled(true);
		createRadioButton(wsdlLocationGroup, FILESYSTEM, bidFileSystem, false);
		fFileSystemComposite = new Composite(wsdlLocationGroup, SWT.NONE);
		fFileSystemComposite.setLayout(new GridLayout(3, false));
		nameFSLabel = new Label(fFileSystemComposite, SWT.NONE);
		nameFSLabel.setText(PATH_TO_WSDL);
		nameFSField = new Text(fFileSystemComposite, SWT.BORDER | SWT.SINGLE
				| SWT.READ_ONLY);
		GridData wsdlFSGridData = new GridData(SWT.FILL, SWT.CENTER, true,
				false);
		wsdlFSGridData.widthHint = WIDTH_EDIT_FIELD;
		nameFSField.setLayoutData(wsdlFSGridData);
		String pathFSToInitialWsdl = getPathToInitialWsdl();
/*		if (null != pathFSToInitialWsdl) {
			nameFSField.setText(pathFSToInitialWsdl);
			nameFSField.setSelection(nameFSField.getCharCount());
		}*/
		fileSystemButton = new Button(fFileSystemComposite, SWT.PUSH);
		fileSystemButton.setText(BROWSE_SF);
		fileSystemButton.setLayoutData(new GridData());
		fileSystemButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent e) {
				String result = DialogSupport.openFileSelectionDialog(
						getShell(), WSDL);
				if (result != null) {
					nameFSField.setText(result);
					setPageComplete(validatePage());
				}
			}
		});
		fFileSystemComposite.setEnabled(false);
		nameFSField.setEnabled(false);
		nameFSLabel.setEnabled(false);
		fileSystemButton.setEnabled(false);
		createRadioButton(wsdlLocationGroup, SERVICE_REGISTRY,
				bidServiceRegistry, false);
		fServiceRegistryComposite = new Composite(wsdlLocationGroup, SWT.NONE);
		fServiceRegistryComposite.setLayout(new GridLayout(3, false));

		nameLabel = new Label(fServiceRegistryComposite, SWT.NONE);
		nameLabel.setText(URL_TO_WSDL);
		nameField = new Text(fServiceRegistryComposite, SWT.BORDER | SWT.SINGLE
				| SWT.READ_ONLY);
		GridData wsdlSRGridData = new GridData(SWT.FILL, SWT.CENTER, true,
				false);
		wsdlSRGridData.widthHint = WIDTH_EDIT_FIELD;
		nameField.setLayoutData(wsdlSRGridData);
		serviceRegisrtyButton = new Button(fServiceRegistryComposite, SWT.PUSH);
		serviceRegisrtyButton.setText(BROWSE_SR);
		serviceRegisrtyButton.setLayoutData(new GridData());
		serviceRegisrtyButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent e) {
				showWindowWithListOfSR();
				PlatformUI.getWorkbench().getHelpSystem().setHelp(parent,
						"org.eclipse.swordfish.tooling.doc" + helpId());
			}
		});
		fServiceRegistryComposite.setEnabled(false);
		nameField.setEnabled(false);
		nameLabel.setEnabled(false);
		serviceRegisrtyButton.setEnabled(false);

		if (!isProvider()) {
			Group providerEndpointGroup = new Group(control, SWT.NONE);
			GridLayout endpointLayout = new GridLayout(1, true);
			GridData endpointData = new GridData();
			endpointData.horizontalAlignment = SWT.FILL;
			providerEndpointGroup.setLayout(endpointLayout);
			providerEndpointGroup.setLayoutData(endpointData);
			providerEndpointGroup.setText(PROVIDER_ENDPOINT);

			createRadioButton(providerEndpointGroup, STATIC_ENDPOINT,
					bidStaticEndpoint, true);
			createRadioButton(providerEndpointGroup, DYNAMIC_ENDPOINT,
					bidDynamicLookup, false);

			Composite buttons = new Composite(control, SWT.NONE);
			FillLayout buttonsLayout = new FillLayout(SWT.VERTICAL);
			buttonsLayout.marginWidth = EXAMPLE_CODE_MARGIN_WIDTH;
			buttonsLayout.marginHeight = EXAMPLE_CODE_MARGIN_HEIGHT;
			buttons.setLayout(buttonsLayout);
			doGenerateExampleCode = new Button(buttons, SWT.CHECK);
			doGenerateExampleCode.setText(GENERATE_EXAMPLE_CODE);
			doGenerateExampleCode.setSelection(true);
		}

		validatePage();
		setControl(control);

		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent,
				"org.eclipse.swordfish.tooling.doc" + helpId());
	}

	private String helpId() {
		if (isProvider()) {
			return ".create_provider_wsdl";
		} else {
			return ".create_consumer_wsdl";
		}
	}

	private void showWindowWithListOfSR() {
		RegistryAccess ra = null;
		try {
			String serviceRegistryURL = Activator.getDefault()
					.getPreferenceStore().getString(
							PreferenceConstants.REGISTRY_URL);
			ra = new RegistryAccess(serviceRegistryURL);
			if (null == ra) {
				MessageDialog.openInformation(getShell(), SERVICE_REGISTRY,
						MESSAGE_SR_UNAVAILABLE);
			} else {
				if (ra.getRegisteredServices().size() == 0) {
					MessageDialog.openInformation(getShell(), SERVICE_REGISTRY,
							MESSAGE_SR_IS_EMPTY);
				} else {
					String result = ServiceRegistryWindow
							.selectResourceFromServiceRegistry(getShell(), WSDL);
					if (result != null) {
						nameField.setText(result);
						Map<QName, URL> services = getServices();
						currentListURL = null;
						for (Map.Entry<QName, URL> entry : services.entrySet()) {
							QName key = entry.getKey();
							URL value = entry.getValue();
							if (key.getNamespaceURI().equals(result)) {
								if (!value.equals(currentListURL)) {
									currentListQName = key.toString();
									currentListURL = value;
									setPageComplete(validatePage());
								}
							}
						}
					}
				}
			}
		} catch (Exception e1) {
			MessageDialog.openInformation(getShell(), SERVICE_REGISTRY,
					MESSAGE_SR_UNAVAILABLE);
		}
	}

	private Map<QName, URL> getServices() {
		Map<QName, URL> services = null;
		try {
			RegistryAccess ra = null;
			String serviceRegistryURL = Activator.getDefault()
					.getPreferenceStore().getString(
							PreferenceConstants.REGISTRY_URL);
			ra = new RegistryAccess(serviceRegistryURL);
			services = ra.getRegisteredServices();
			return services;
		} catch (Exception e) {
			return null;
		}
	}

	private IStructuredSelection getInitialSelection() {
		IWizard wizard = getWizard();
		if (wizard instanceof NewWizard) {
			return ((NewWizard) wizard).getSelection();
		} else {
			return null;
		}
	}

	/**
	 * Method returns path to initially selected wsdl if any
	 * 
	 * @return path to initially selected wsdl or <code>null</code> if no wsdl
	 *         file was selected
	 */
	private String getPathToInitialWsdl() {
		IStructuredSelection selection = getInitialSelection();
		if ((selection != null) && !selection.isEmpty()) {
			Object obj = selection.getFirstElement();
			if (obj instanceof IFile) {
				IFile file = (IFile) obj;
				if (WSDL.equals(file.getFileExtension())) {
					return file.getLocation().toOSString();
				}
			}
		}
		return null;
	}

	protected boolean validatePage() {
		String path = getPathToWSDL();
		return (null != path) && (new File(path).exists());
	}

	@Override
	public boolean isPageComplete() {
		return validatePage();
	}

	/**
	 * Returns the path to WSDL selected or path to initially selected by import
	 * wizard call WSDL
	 * 
	 * @return the path to WSDL selected or empty string if nothing is selected
	 */
	public String getPathToWSDL() {
		if (null == nameFSField) {
			return getPathToInitialWsdl();
		}
		switch (bidSelected) {
		case bidWorkspace:
			try {
				if (selectedResource.getLocation().toOSString().toLowerCase()
						.endsWith(WSDL)) {
					return selectedResource.getLocation().toOSString();
				} else {
					return null;
				}
			} catch (Exception e) {
				return null;
			}
		case bidFileSystem:
			return nameFSField.getText();
		case bidServiceRegistry:
			try {
				if (!currentListQName.equals(currentTempFileContent)) {
					InputStream is = currentListURL.openStream();
					OutputStream out = new FileOutputStream(tempFile);
					byte buf[] = new byte[1024];
					int len;
					while ((len = is.read(buf)) > 0) {
						out.write(buf, 0, len);
					}
					out.close();
					is.close();
					tempWSDLPath = tempFile.getPath();
					currentTempFileContent = currentListQName;
				}
			} catch (Exception e) {
				tempWSDLPath = null;
			}
			return tempWSDLPath;
		}
		return null;
	}

	/**
	 * Returns is creating project provider
	 * 
	 * @return boolean
	 */
	public boolean isProvider() {
		String wizardName = this.getWizard().getClass().getName();
		if (wizardName.contains(CONSUMER)) {
			return false;
		} else {
			return true;
		}
	}

	/**
	 * Returns true if check "Generate Static Endpoint select"
	 * 
	 * @return boolean
	 */
	public boolean doGenerateStaticEndpoint() {
		return bidEndpointSelected == bidStaticEndpoint;
	}

	/**
	 * Returns true if check "Generate Example Code select"
	 * 
	 * @return boolean
	 */
	public boolean doGenerateExampleCode() {
		if (null == doGenerateExampleCode) {
			return true;
		} else {
			return doGenerateExampleCode.getSelection();
		}
	}

	protected Button createRadioButton(Composite parent, String label, int id,
			boolean checked) {
		Button button = new Button(parent, SWT.RADIO);
		button.setText(label);
		button.setData(new Integer(id));
		button.setSelection(checked);

		button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent event) {
				Button b = (Button) event.widget;
				int bid = ((Integer) b.getData()).intValue();
				buttonPressed(bid, b.getSelection());
			}
		});
		return button;
	}

	protected void buttonPressed(int id, boolean checked) {
		switch (id) {
		case bidWorkspace:
		case bidFileSystem:
		case bidServiceRegistry:
			if (checked == false) {
				return;
			}
			fWorkspaceComposite.setEnabled(id == bidWorkspace);
			nameFSField.setEnabled(id == bidFileSystem);
			nameFSLabel.setEnabled(id == bidFileSystem);
			fileSystemButton.setEnabled(id == bidFileSystem);

			fFileSystemComposite.setEnabled(id == bidFileSystem);
			drillDown.setEnabled(id == bidWorkspace);

			fServiceRegistryComposite.setEnabled(id == bidServiceRegistry);
			nameField.setEnabled(id == bidServiceRegistry);
			nameLabel.setEnabled(id == bidServiceRegistry);
			serviceRegisrtyButton.setEnabled(id == bidServiceRegistry);

			bidSelected = id;
			setPageComplete(validatePage());
			break;

		case bidStaticEndpoint:
		case bidDynamicLookup:
			bidEndpointSelected = id;
			break;

		default:
			break;
		}
	}

}

/**
 * Filter for *.wsdl files
 * 
 * @return boolean
 */
class WSDLFilter extends ViewerFilter {
	private static final String WSDL = "wsdl";

	@Override
	public boolean select(Viewer viewer, Object parentElement, Object element) {
		IResource resource = null;
		if (element instanceof IFile) {
			resource = (IFile) element;
		} else {
			return true;
		}
		if (resource != null) {
			String name = resource.getName();
			if (name.endsWith(WSDL)) {
				return true;
			}
		}
		return false;
	}
}
