/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards;

import org.eclipse.jface.wizard.IWizardPage;

import org.eclipse.ui.IImportWizard;
/**
 * class ServiceWsdlImportWizard
 * 
 * @author amarkevich
 */
public class ServiceWsdlImportWizard extends ServiceWsdlWizard implements
		IImportWizard {

	@Override
	public void addPage(IWizardPage page) {
		//we don't need the wsdl source page to show up in case of import
		if (page instanceof PluginContentWsdlWizardPage) {
			page.setWizard(this);
			PluginContentWsdlWizardPage contentWsdlPage = (PluginContentWsdlWizardPage) page;
			String pathToWSDL = contentWsdlPage.getPathToWSDL();
			if ((null == pathToWSDL) ||  (pathToWSDL.length() == 0)) {
				super.addPage(page);
			}
		} else {
			super.addPage(page);
		}
	}

	
}
