/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards.actions;

import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swordfish.tooling.ui.Activator;
import org.eclipse.swordfish.tooling.ui.wizards.generators.JaxWsClientJavaCodeGenerator;
import org.eclipse.swordfish.tooling.ui.wizards.generators.data.ConsumerProjectInformation;

/**
 * Job that manipulates the code of a provider service implementation
 */
public class ProviderServiceManipulationJob extends WorkspaceJob {
	private IProject project;
	private String serviceImplementationClass;
	private List<ConsumerProjectInformation> consumerInfo;


	/**
	 * Create the code manipulation job
	 * @param project - the current project
	 * @param serviceImplementationClass - the class to be manipulated
	 * @param consumerInfo - the consumer project information list
	 */
	public ProviderServiceManipulationJob(IProject project,
			String serviceImplementationClass,
			List<ConsumerProjectInformation> consumerInfo) {
		super("CXF code manipulation");
		this.project = project;
		this.serviceImplementationClass = serviceImplementationClass;
		this.consumerInfo = consumerInfo;
	}

	@Override
	public IStatus runInWorkspace(IProgressMonitor monitor)
			throws CoreException {
		try {
			IType providerImpl = JavaCore.create(project).findType(serviceImplementationClass);
			
			JaxWsClientJavaCodeGenerator codeGen = new JaxWsClientJavaCodeGenerator();
			codeGen.generate(consumerInfo);
			
			addConsumerClientImports(providerImpl.getCompilationUnit(), codeGen.getImports());
			addConsumerClientMembers(providerImpl, codeGen.getFields());
			addConsumerClientAccessorMethods(providerImpl, codeGen.getAccessorMethods());

		} catch (Exception e) {
			return new Status(IStatus.ERROR, Activator.getDefault()
					.getPluginId(), IStatus.ERROR, e.getClass().getName()
					+ " : " + e.getMessage(), e);
		}
		return Status.OK_STATUS;
	}

	private void addConsumerClientAccessorMethods(IType serviceImpl,
			List<String> methods) throws JavaModelException {
		for (String method : methods) {
			serviceImpl.createMethod(method, null, true, null);
		}
	}

	private void addConsumerClientImports(ICompilationUnit compUnit,
			List<String> imports) throws JavaModelException {
		for (String imp : imports) {
			compUnit.createImport(imp, null, null);
		}
	}

	private void addConsumerClientMembers(IType serviceImpl,
			List<String> members) throws JavaModelException {
		for (String member : members) {
			serviceImpl.createField(member, null, true, null);
		}
	}

}