package org.eclipse.swordfish.tooling.ui.wizards.generators;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.swordfish.tooling.ui.Logger;
import org.eclipse.swordfish.tooling.ui.helper.TemplateProcessor;
import org.eclipse.swordfish.tooling.ui.wizards.TemplateConstants;

public class CxfConsumerSpringEndpointGenerator implements CodeGenerator {
	private static final String TEMPLATE_CXF_LOCATION = "/templates/consumer/META-INF/spring/jaxws-consumer.xml"; //$NON-NLS-1$
	private static final String TEMPLATE_CXF_WITHOUT_INVOKER_LOCATION = "/templates/consumer/META-INF/spring/jaxws-consumer-without-invoker.xml"; //$NON-NLS-1$	

	private String name;
	private String targetNamespace;
	private String implementor;
	private String url;
	private String commentOpen;
	private String commentClose;
	private String templateName;
	private InputStreamProvider templateProvider;


	/**
	 * The constructor.
	 * 
	 * @param serviceName - name of the service
	 * @param serviceTargetNamespace - name of the target
	 * @param serviceImplementor - fully qualified name of the class, implementing the service interface
	 * @param serviceURL - url, on which the service is accessible
	 * @param doStaticEndpoint - have to generate static endpoint or not
	 * @param doSampleCode - if true, the invoker activation will be added
	 */
	public CxfConsumerSpringEndpointGenerator(String serviceName, String serviceTargetNamespace,
												String serviceImplementor, String serviceURL, boolean doStaticEndpoint,
												boolean doSampleCode) {
		this.name = serviceName;
		this.targetNamespace = serviceTargetNamespace;
		this.implementor = serviceImplementor;
		this.url = serviceURL;
		this.commentOpen = (doStaticEndpoint ? "" : "<!--");
		this.commentClose = (doStaticEndpoint ? "" : "-->");
		this.templateName = doSampleCode ? TEMPLATE_CXF_LOCATION : TEMPLATE_CXF_WITHOUT_INVOKER_LOCATION;
		this.templateProvider = new DefaultTemplateStreamProvider();

	}

	
	/* (non-Javadoc)
	 * @see org.eclipse.swordfish.tooling.ui.wizards.actions.CodeGenerator#generate()
	 */
	public InputStream generate() {
		InputStream template = null;
		InputStream result = null;

		try {
			template = templateProvider.getInputStream(templateName);
			Map<String, String> replacements = new HashMap<String, String>();
			replacements.put(TemplateConstants.KEY_SERVICE_ID, deCaptitalize(name));
			replacements.put(TemplateConstants.KEY_SERVICE_NAME, name);
			replacements.put(TemplateConstants.KEY_SERVICE_TARGET_NAMESPACE, targetNamespace);
			int index = implementor.lastIndexOf('.');
			replacements.put(TemplateConstants.KEY_SERVICE_PACKAGE, implementor.substring(0, index));

			String serviceImpl = implementor.substring(index + 1);
			replacements.put(TemplateConstants.KEY_SERVICE_IMPL, serviceImpl);

			replacements.put(TemplateConstants.KEY_SERVICE_IMPL_INSTANCE, deCaptitalize(serviceImpl));
			replacements.put(TemplateConstants.KEY_SERVICE_URL, url);

			replacements.put(TemplateConstants.KEY_OPEN_COMMENT, commentOpen);
			replacements.put(TemplateConstants.KEY_CLOSE_COMMENT, commentClose);
			result = new TemplateProcessor(template, replacements).process();

		} catch (IOException ioe) {
			Logger.error("Unable to process template", ioe);
			
		} finally {
			if (template != null) {
				try {
					template.close();
				} catch (IOException ioe2) {
					// ignore
				}
			}
		}
		return result;
	}


	/* (non-Javadoc)
	 * @see org.eclipse.swordfish.tooling.ui.wizards.generators.CodeGenerator#setTemplateStreamProvider(org.eclipse.swordfish.tooling.ui.wizards.generators.InputStreamProvider)
	 */
	public void setTemplateStreamProvider(InputStreamProvider templateProvider) {
		this.templateProvider = templateProvider;
	}

	private String deCaptitalize(String str) {
		return str.substring(0, 1).toLowerCase() + str.substring(1);
	}
}
