/*******************************************************************************
 * Copyright (c) 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards.generators;

import java.util.List;

import javax.xml.transform.TransformerException;

import org.eclipse.swordfish.tooling.ui.helper.ConsumerProjectInformationUtil;
import org.eclipse.swordfish.tooling.ui.helper.SimpleTemplateProcessor;
import org.eclipse.swordfish.tooling.ui.wizards.generators.data.ConsumerProjectInformation;
import org.eclipse.swordfish.tooling.ui.wizards.generators.data.JaxWsClientInformation;

public class JaxWsSpringReferenceGenerator {
	private static final String BEAN_REFERENCE = "beanReference";
	private static final String PROPERTY_NAME = "propertyName";
	private static String CLIENT_TAG = ConsumerProjectInformationUtil.JAXWS_CLIENT_TAG_NAME;
	private static final String NEW_LINE = System.getProperty("line.separator");
	private SimpleTemplateProcessor proc = new SimpleTemplateProcessor(NEW_LINE
			+ "\t\t<spring:property name=\"$propertyName$\" ref=\"$beanReference$\"/>");

	public String generate(List<ConsumerProjectInformation> infos) {
		StringBuffer sb = new StringBuffer();

		if (infos != null) {
			for (ConsumerProjectInformation info : infos) {
				sb.append(generate(info));
			}
		}

		return sb.toString();
	}

	public String generate(ConsumerProjectInformation info) {
		StringBuffer result = new StringBuffer();

		if (info != null && info.getClientRefs() != null) {
			List<JaxWsClientInformation> refList = info.getClientRefs();

			for (JaxWsClientInformation ref : refList) {
				if (hasGenerationContent(ref)) {
					try {
						result.append(generate(ref.getClientID()));

					} catch (TransformerException e) {
						throw new IllegalArgumentException("JAXWS client info invalid " + info, e);
					}
				}
			}
		}
		return result.toString();
	}

	private String generate(String id) throws TransformerException {
		proc.putReplacement(PROPERTY_NAME, deCaptitalize(id));
		proc.putReplacement(BEAN_REFERENCE, id);
		return proc.process();
	}

	private String deCaptitalize(String str) {
		return str.substring(0, 1).toLowerCase() + str.substring(1);
	}

	boolean hasGenerationContent(JaxWsClientInformation clientInfo) {
		return (clientInfo != null)
				&& (clientInfo.getJaxWsClientElement() != null)
				&& (CLIENT_TAG.equals(clientInfo.getJaxWsClientElement().getNodeName()) 
				&& (clientInfo.getClientID()) != null)
				&& (!"".equals(clientInfo.getClientID()));
	}
}
