/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.osgi.compendium.internal.OsgiPropertyPlaceholder;
import org.springframework.osgi.config.ParserUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

class OsgiPropertyPlaceholderDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final String REF = "defaults-ref";
    public static final String PROPERTIES_FIELD = "properties";
    public static final String NESTED_PROPERTIES = "default-properties";

    OsgiPropertyPlaceholderDefinitionParser() {
    }

    protected Class getBeanClass(Element element) {
        return OsgiPropertyPlaceholder.class;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ParserUtils.parseCustomAttributes(element, builder, new ParserUtils.AttributeCallback(){

            public boolean process(Element parent, Attr attribute, BeanDefinitionBuilder builder) {
                String name = attribute.getLocalName();
                String value = attribute.getValue();
                if (OsgiPropertyPlaceholderDefinitionParser.REF.equals(name)) {
                    builder.addPropertyReference(OsgiPropertyPlaceholderDefinitionParser.PROPERTIES_FIELD, value);
                    return false;
                }
                return true;
            }
        });
        Element nestedElement = DomUtils.getChildElementByTagName((Element)element, (String)NESTED_PROPERTIES);
        if (nestedElement != null) {
            if (element.hasAttribute(REF)) {
                parserContext.getReaderContext().error("nested properties cannot be declared if 'defaults-ref' attribute is specified", (Object)element);
            }
            builder.addPropertyValue(PROPERTIES_FIELD, (Object)parserContext.getDelegate().parsePropsElement(nestedElement));
        }
    }
}

