/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.internal.aop;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.service.ServiceUnavailableException;
import org.springframework.osgi.service.importer.internal.aop.ServiceInvoker;
import org.springframework.util.Assert;

public class ServiceStaticInterceptor
extends ServiceInvoker {
    private static final int hashCode = ServiceStaticInterceptor.class.hashCode() * 13;
    private final ServiceReference reference;
    private final BundleContext bundleContext;

    public ServiceStaticInterceptor(BundleContext context, ServiceReference reference) {
        Assert.notNull((Object)context);
        Assert.notNull((Object)reference, (String)"a not null service reference is required");
        this.bundleContext = context;
        this.reference = reference;
    }

    protected Object getTarget() {
        Object target;
        if (this.reference.getBundle() != null && (target = this.bundleContext.getService(this.reference)) != null) {
            return target;
        }
        throw new ServiceUnavailableException(this.reference);
    }

    public ServiceReference getServiceReference() {
        return this.reference;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ServiceStaticInterceptor) {
            ServiceStaticInterceptor oth = (ServiceStaticInterceptor)other;
            return this.reference.equals(oth.reference) && this.bundleContext.equals(oth.bundleContext);
        }
        return false;
    }

    public int hashCode() {
        return hashCode;
    }
}

