/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.internal.collection;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.springframework.osgi.service.importer.internal.collection.DynamicCollection;

public class DynamicList
extends DynamicCollection
implements List,
RandomAccess {
    public DynamicList() {
    }

    public DynamicList(Collection c) {
        super(c);
    }

    public DynamicList(int size) {
        super(size);
    }

    public void add(int index, Object o) {
        super.add(index, o);
    }

    public boolean addAll(int index, Collection c) {
        return this.storage.addAll(index, c);
    }

    public Object get(int index) {
        return this.storage.get(index);
    }

    public int indexOf(Object o) {
        return this.storage.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.storage.lastIndexOf(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator() {
        DynamicListIterator iter = new DynamicListIterator(0);
        Map map = this.iterators;
        synchronized (map) {
            this.iterators.put(iter, null);
        }
        return iter;
    }

    public ListIterator listIterator(int index) {
        return new DynamicListIterator(index);
    }

    public Object remove(int index) {
        return super.remove(index);
    }

    public Object set(int index, Object o) {
        return this.storage.set(index, o);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.storage.subList(fromIndex, toIndex);
    }

    private class DynamicListIterator
    extends DynamicCollection.DynamicIterator
    implements ListIterator {
        private DynamicListIterator(int index) {
            this.cursor = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Object o) {
            this.removalAllowed = false;
            Object object = this.lock;
            synchronized (object) {
                DynamicList.this.add(this.cursor, o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasPrevious() {
            Object object = this.lock;
            synchronized (object) {
                return this.cursor - 1 >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int nextIndex() {
            Object object = this.lock;
            synchronized (object) {
                return this.cursor;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object previous() {
            this.removalAllowed = true;
            if (this.hasPrevious()) {
                Object object = this.lock;
                synchronized (object) {
                    return DynamicList.this.storage.get(--this.cursor);
                }
            }
            throw new NoSuchElementException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int previousIndex() {
            Object object = this.lock;
            synchronized (object) {
                return this.cursor - 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(Object o) {
            if (!this.removalAllowed) {
                throw new IllegalStateException();
            }
            Object object = this.lock;
            synchronized (object) {
                DynamicList.this.storage.set(this.cursor - 1, o);
            }
        }
    }
}

