/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.util.internal;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.Assert;

public abstract class BeanFactoryUtils {
    public static String[] getTransitiveDependenciesForBean(ConfigurableListableBeanFactory beanFactory, String beanName, boolean rawFactoryBeans, Class type) {
        Assert.notNull((Object)beanFactory);
        Assert.hasText((String)beanName);
        Assert.isTrue((boolean)beanFactory.containsBean(beanName), (String)("no bean by name [" + beanName + "] can be found"));
        LinkedHashSet beans = new LinkedHashSet();
        BeanFactoryUtils.getTransitiveBeans(beanFactory, beanName, rawFactoryBeans, beans);
        if (type != null) {
            Iterator iter = beans.iterator();
            while (iter.hasNext()) {
                String bean = (String)iter.next();
                if (beanFactory.isTypeMatch(bean, type)) continue;
                iter.remove();
            }
        }
        return beans.toArray(new String[beans.size()]);
    }

    private static void getTransitiveBeans(ConfigurableListableBeanFactory beanFactory, String beanName, boolean rawFactoryBeans, Set beanNames) {
        String[] beans = beanFactory.getDependenciesForBean(org.springframework.beans.factory.BeanFactoryUtils.transformedBeanName((String)beanName));
        for (int i = 0; i < beans.length; ++i) {
            String bean = beans[i];
            if (rawFactoryBeans && beanFactory.isFactoryBean(bean)) {
                bean = "&" + beans[i];
            }
            if (beanNames.contains(bean)) continue;
            beanNames.add(bean);
            BeanFactoryUtils.getTransitiveBeans(beanFactory, bean, rawFactoryBeans, beanNames);
        }
    }
}

