/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.naming.NamingException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.jms.AddressType;
import org.apache.cxf.transport.jms.ClientBehaviorPolicyType;
import org.apache.cxf.transport.jms.ClientConfig;
import org.apache.cxf.transport.jms.DestinationStyleType;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSNamingPropertyType;
import org.apache.cxf.transport.jms.ServerBehaviorPolicyType;
import org.apache.cxf.transport.jms.ServerConfig;
import org.apache.cxf.transport.jms.SessionPoolType;
import org.springframework.jms.connection.SingleConnectionFactory;
import org.springframework.jms.connection.UserCredentialsConnectionFactoryAdapter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.JndiDestinationResolver;
import org.springframework.jndi.JndiTemplate;

public class JMSOldConfigHolder {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSOldConfigHolder.class);
    private ClientConfig clientConfig;
    private ClientBehaviorPolicyType runtimePolicy;
    private AddressType address;
    private SessionPoolType sessionPool;
    private JMSConfiguration jmsConfig;
    private ServerConfig serverConfig;
    private ServerBehaviorPolicyType serverBehavior;

    private ConnectionFactory getConnectionFactoryFromJndi(String connectionFactoryName, String userName, String password, JndiTemplate jt) {
        if (connectionFactoryName == null) {
            return null;
        }
        try {
            ConnectionFactory connectionFactory = (ConnectionFactory)jt.lookup(connectionFactoryName);
            UserCredentialsConnectionFactoryAdapter uccf = new UserCredentialsConnectionFactoryAdapter();
            uccf.setUsername(userName);
            uccf.setPassword(password);
            uccf.setTargetConnectionFactory(connectionFactory);
            SingleConnectionFactory scf = new SingleConnectionFactory();
            scf.setTargetConnectionFactory((ConnectionFactory)uccf);
            return scf;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public JMSConfiguration createJMSConfigurationFromEndpointInfo(Bus bus, EndpointInfo endpointInfo, boolean isConduit) {
        this.jmsConfig = new JMSConfiguration();
        this.address = endpointInfo.getTraversedExtensor(new AddressType(), AddressType.class);
        this.clientConfig = endpointInfo.getTraversedExtensor(new ClientConfig(), ClientConfig.class);
        this.runtimePolicy = endpointInfo.getTraversedExtensor(new ClientBehaviorPolicyType(), ClientBehaviorPolicyType.class);
        this.serverConfig = endpointInfo.getTraversedExtensor(new ServerConfig(), ServerConfig.class);
        this.sessionPool = endpointInfo.getTraversedExtensor(new SessionPoolType(), SessionPoolType.class);
        this.serverBehavior = endpointInfo.getTraversedExtensor(new ServerBehaviorPolicyType(), ServerBehaviorPolicyType.class);
        String name = endpointInfo.getName().toString() + (isConduit ? ".jms-conduit" : ".jms-destination");
        Configurer configurer = bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(name, this);
        }
        JndiTemplate jt = new JndiTemplate();
        jt.setEnvironment(JMSOldConfigHolder.getInitialContextEnv(this.address));
        ConnectionFactory cf = this.getConnectionFactoryFromJndi(this.address.getJndiConnectionFactoryName(), this.address.getConnectionUserName(), this.address.getConnectionPassword(), jt);
        boolean pubSubDomain = false;
        if (this.address.isSetDestinationStyle()) {
            pubSubDomain = DestinationStyleType.TOPIC == this.address.getDestinationStyle();
        }
        this.jmsConfig.setConnectionFactory(cf);
        this.jmsConfig.setDurableSubscriptionName(this.serverBehavior.getDurableSubscriberName());
        this.jmsConfig.setExplicitQosEnabled(true);
        this.jmsConfig.setMessageSelector(this.serverBehavior.getMessageSelector());
        if (this.runtimePolicy.isSetMessageType()) {
            this.jmsConfig.setMessageType(this.runtimePolicy.getMessageType().value());
        }
        this.jmsConfig.setPubSubDomain(pubSubDomain);
        this.jmsConfig.setPubSubNoLocal(true);
        this.jmsConfig.setReceiveTimeout(this.clientConfig.getClientReceiveTimeout());
        this.jmsConfig.setSubscriptionDurable(this.serverBehavior.isSetDurableSubscriberName());
        long timeToLive = isConduit ? this.clientConfig.getMessageTimeToLive() : this.serverConfig.getMessageTimeToLive();
        this.jmsConfig.setTimeToLive(timeToLive);
        if (this.address.isSetUseJms11()) {
            this.jmsConfig.setUseJms11(this.address.isUseJms11());
        }
        boolean useJndi = this.address.isSetJndiDestinationName();
        this.jmsConfig.setUseJndi(useJndi);
        this.jmsConfig.setSessionTransacted(this.serverBehavior.isSetTransactional());
        if (useJndi) {
            JndiDestinationResolver jndiDestinationResolver = new JndiDestinationResolver();
            jndiDestinationResolver.setJndiTemplate(jt);
            this.jmsConfig.setDestinationResolver((DestinationResolver)jndiDestinationResolver);
            this.jmsConfig.setTargetDestination(this.address.getJndiDestinationName());
            this.jmsConfig.setReplyDestination(this.address.getJndiReplyDestinationName());
        } else {
            this.jmsConfig.setTargetDestination(this.address.getJmsDestinationName());
            this.jmsConfig.setReplyDestination(this.address.getJmsReplyDestinationName());
        }
        this.jmsConfig.setConnectionFactory(cf);
        return this.jmsConfig;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public ClientBehaviorPolicyType getRuntimePolicy() {
        return this.runtimePolicy;
    }

    public void setRuntimePolicy(ClientBehaviorPolicyType runtimePolicy) {
        this.runtimePolicy = runtimePolicy;
    }

    public AddressType getAddress() {
        return this.address;
    }

    public void setAddress(AddressType address) {
        this.address = address;
    }

    public SessionPoolType getSessionPool() {
        return this.sessionPool;
    }

    public void setSessionPool(SessionPoolType sessionPool) {
        this.sessionPool = sessionPool;
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public ServerBehaviorPolicyType getServerBehavior() {
        return this.serverBehavior;
    }

    public void setServerBehavior(ServerBehaviorPolicyType serverBehavior) {
        this.serverBehavior = serverBehavior;
    }

    public static Properties getInitialContextEnv(AddressType addrType) {
        Properties env = new Properties();
        ListIterator<JMSNamingPropertyType> listIter = addrType.getJMSNamingProperty().listIterator();
        while (listIter.hasNext()) {
            JMSNamingPropertyType propertyPair = listIter.next();
            if (null == propertyPair.getValue()) continue;
            env.setProperty(propertyPair.getName(), propertyPair.getValue());
        }
        if (LOG.isLoggable(Level.FINE)) {
            Enumeration<?> props = env.propertyNames();
            while (props.hasMoreElements()) {
                String name = (String)props.nextElement();
                String value = env.getProperty(name);
                LOG.log(Level.FINE, "Context property: " + name + " | " + value);
            }
        }
        return env;
    }
}

