/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.runtime.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.runtime.impl.AbstractComponentContext;
import org.apache.servicemix.jbi.runtime.impl.InOnlyImpl;
import org.apache.servicemix.jbi.runtime.impl.InOptionalOutImpl;
import org.apache.servicemix.jbi.runtime.impl.InOutImpl;
import org.apache.servicemix.jbi.runtime.impl.MessageExchangeFactoryImpl;
import org.apache.servicemix.jbi.runtime.impl.MessageExchangeImpl;
import org.apache.servicemix.jbi.runtime.impl.RobustInOnlyImpl;
import org.apache.servicemix.jbi.runtime.impl.ServiceEndpointImpl;
import org.apache.servicemix.nmr.api.AbortedException;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Pattern;
import org.apache.servicemix.nmr.api.Reference;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.api.internal.InternalExchange;
import org.apache.servicemix.nmr.api.service.ServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliveryChannelImpl
implements DeliveryChannel {
    public static final String SEND_SYNC = "javax.jbi.messaging.sendSync";
    private static final String SENDER_ENDPOINT = "org.apache.servicemix.senderEndpoint";
    private final AtomicBoolean closed;
    private final AbstractComponentContext context;
    private final BlockingQueue<Exchange> queue;
    private final Channel channel;
    private static final QName DEFAULT_SERVICE_NAME = new QName("urn:servicemix.apache.org", "jbi");

    public DeliveryChannelImpl(AbstractComponentContext context, Channel channel, BlockingQueue<Exchange> queue) {
        this.context = context;
        this.channel = channel;
        this.queue = queue;
        this.closed = new AtomicBoolean(false);
    }

    public void close() throws MessagingException {
        this.channel.close();
        this.closed.set(true);
    }

    public MessageExchangeFactory createExchangeFactory() {
        return new MessageExchangeFactoryImpl(this.closed);
    }

    public MessageExchangeFactory createExchangeFactory(QName interfaceName) {
        MessageExchangeFactoryImpl factory = new MessageExchangeFactoryImpl(this.closed);
        factory.setInterfaceName(interfaceName);
        return factory;
    }

    public MessageExchangeFactory createExchangeFactoryForService(QName serviceName) {
        MessageExchangeFactoryImpl factory = new MessageExchangeFactoryImpl(this.closed);
        factory.setServiceName(serviceName);
        return factory;
    }

    public MessageExchangeFactory createExchangeFactory(ServiceEndpoint endpoint) {
        MessageExchangeFactoryImpl factory = new MessageExchangeFactoryImpl(this.closed);
        factory.setEndpoint(endpoint);
        return factory;
    }

    public MessageExchange accept() throws MessagingException {
        try {
            Exchange exchange = this.queue.take();
            if (exchange == null) {
                return null;
            }
            MessageExchange me = this.getMessageExchange(exchange);
            ((MessageExchangeImpl)me).beforeReceived();
            return me;
        }
        catch (InterruptedException e) {
            throw new MessagingException((Throwable)e);
        }
    }

    public MessageExchange accept(long timeout) throws MessagingException {
        try {
            long t0;
            long cur = t0 = System.currentTimeMillis();
            while (cur - t0 < timeout) {
                Exchange exchange = this.queue.poll(t0 + timeout - cur, TimeUnit.MILLISECONDS);
                if (exchange == null || exchange.getError() instanceof AbortedException) {
                    cur = System.currentTimeMillis();
                    continue;
                }
                MessageExchange me = this.getMessageExchange(exchange);
                ((MessageExchangeImpl)me).beforeReceived();
                return me;
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new MessagingException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageExchange getMessageExchange(Exchange exchange) {
        MessageExchange me;
        Exchange exchange2 = exchange;
        synchronized (exchange2) {
            me = (MessageExchange)exchange.getProperty(MessageExchange.class);
            if (me == null) {
                if (exchange.getPattern() == Pattern.InOnly) {
                    me = new InOnlyImpl(exchange);
                } else if (exchange.getPattern() == Pattern.InOptionalOut) {
                    me = new InOptionalOutImpl(exchange);
                } else if (exchange.getPattern() == Pattern.InOut) {
                    me = new InOutImpl(exchange);
                } else if (exchange.getPattern() == Pattern.RobustInOnly) {
                    me = new RobustInOnlyImpl(exchange);
                } else {
                    throw new IllegalStateException("Unknown pattern: " + exchange.getPattern());
                }
                exchange.setProperty(MessageExchange.class, (Object)me);
            }
        }
        if (((InternalExchange)exchange).getDestination() != null && me.getEndpoint() == null) {
            InternalEndpoint ep = ((InternalExchange)exchange).getDestination();
            Map props = this.context.getNmr().getEndpointRegistry().getProperties((Object)ep);
            String strSvcName = (String)props.get("SERVICE_NAME");
            QName serviceName = strSvcName != null && strSvcName.length() > 0 ? QName.valueOf(strSvcName) : DEFAULT_SERVICE_NAME;
            String endpointName = (String)props.get("ENDPOINT_NAME");
            if (endpointName == null) {
                endpointName = (String)props.get("NAME");
            }
            me.setEndpoint((ServiceEndpoint)new ServiceEndpointImpl(serviceName, endpointName));
        }
        return me;
    }

    public void send(MessageExchange exchange) throws MessagingException {
        assert (exchange != null);
        DeliveryChannelImpl.createTarget(this.context.getNmr(), exchange);
        exchange.setProperty(SEND_SYNC, null);
        ((MessageExchangeImpl)exchange).afterSend();
        InternalExchange ie = (InternalExchange)((MessageExchangeImpl)exchange).getInternalExchange();
        this.getChannelToUse(ie).send((Exchange)ie);
    }

    public boolean sendSync(MessageExchange exchange) throws MessagingException {
        assert (exchange != null);
        DeliveryChannelImpl.createTarget(this.context.getNmr(), exchange);
        exchange.setProperty(SEND_SYNC, (Object)Boolean.TRUE);
        ((MessageExchangeImpl)exchange).afterSend();
        InternalExchange ie = (InternalExchange)((MessageExchangeImpl)exchange).getInternalExchange();
        return this.getChannelToUse(ie).sendSync((Exchange)ie);
    }

    public boolean sendSync(MessageExchange exchange, long timeout) throws MessagingException {
        assert (exchange != null);
        DeliveryChannelImpl.createTarget(this.context.getNmr(), exchange);
        exchange.setProperty(SEND_SYNC, (Object)Boolean.TRUE);
        ((MessageExchangeImpl)exchange).afterSend();
        InternalExchange ie = (InternalExchange)((MessageExchangeImpl)exchange).getInternalExchange();
        return this.getChannelToUse(ie).sendSync((Exchange)ie, timeout);
    }

    protected Channel getChannelToUse(InternalExchange exchange) {
        Channel channelToUse;
        block5: {
            channelToUse = this.channel;
            if (exchange.getSource() == null) {
                try {
                    String sender = (String)exchange.getProperty(SENDER_ENDPOINT);
                    if (sender == null) break block5;
                    int idx = sender.lastIndexOf(58);
                    String svc = sender.substring(0, idx);
                    String ep = sender.substring(idx + 1);
                    Map props = ServiceHelper.createMap((String[])new String[]{"SERVICE_NAME", svc, "ENDPOINT_NAME", ep});
                    List eps = this.channel.getNMR().getEndpointRegistry().query(props);
                    if (eps != null && eps.size() == 1) {
                        channelToUse = ((InternalEndpoint)eps.get(0)).getChannel();
                    }
                }
                catch (Throwable throwable) {}
            } else {
                channelToUse = exchange.getSource().getChannel();
            }
        }
        return channelToUse;
    }

    public static void createTarget(NMR nmr, MessageExchange messageExchange) {
        DeliveryChannelImpl.createTarget(nmr, ((MessageExchangeImpl)messageExchange).getInternalExchange());
    }

    public static void createTarget(NMR nmr, Exchange exchange) {
        if (exchange.getTarget() == null) {
            HashMap<String, String> props = new HashMap<String, String>();
            ServiceEndpoint ep = MessageExchangeImpl.getEndpoint(exchange);
            if (ep != null) {
                props.put("SERVICE_NAME", ep.getServiceName().toString());
                props.put("ENDPOINT_NAME", ep.getEndpointName());
            } else {
                QName serviceName = MessageExchangeImpl.getService(exchange);
                if (serviceName != null) {
                    props.put("SERVICE_NAME", serviceName.toString());
                } else {
                    QName interfaceName = MessageExchangeImpl.getInterfaceName(exchange);
                    if (interfaceName != null) {
                        props.put("INTERFACE_NAME", interfaceName.toString());
                    }
                }
            }
            if (props.isEmpty()) {
                throw new IllegalStateException("No endpoint, service or interface name specified for routing");
            }
            Reference target = nmr.getEndpointRegistry().lookup(props);
            exchange.setTarget(target);
        }
    }
}

