/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.handlers.security;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSPasswordCallback;

public class BaseSecurityCallbackHandler
implements CallbackHandler {
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null || callbacks.length == 0) {
            throw new IllegalStateException("callbacks is null or empty");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof WSPasswordCallback)) {
                throw new UnsupportedCallbackException(callbacks[i]);
            }
            this.processCallback((WSPasswordCallback)callbacks[i]);
        }
    }

    protected void processCallback(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        switch (callback.getUsage()) {
            case 1: {
                this.processDecrypt(callback);
                break;
            }
            case 2: {
                this.processUsernameToken(callback);
                break;
            }
            case 3: {
                this.processSignature(callback);
                break;
            }
            case 4: {
                this.processKeyName(callback);
                break;
            }
            case 5: {
                this.processUsernameTokenUnkown(callback);
                break;
            }
            default: {
                throw new UnsupportedCallbackException((Callback)callback);
            }
        }
    }

    protected void processDecrypt(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected void processUsernameToken(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected void processSignature(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected void processKeyName(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected void processUsernameTokenUnkown(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }
}

