/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.servicemix.expression.PropertyExpression;

public class FileExtensionPropertyExpression
extends PropertyExpression {
    private final String extension;
    private boolean deleteExistingExtension = true;

    public FileExtensionPropertyExpression(String fileExtension) {
        super("org.apache.servicemix.file.name");
        this.extension = fileExtension;
    }

    public FileExtensionPropertyExpression(String extension, boolean deleteExistingExtension) {
        super("org.apache.servicemix.file.name");
        this.extension = extension;
        this.deleteExistingExtension = deleteExistingExtension;
    }

    public Object evaluate(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        Object result = super.evaluate(exchange, message);
        if (result != null && result instanceof String) {
            return this.removeExtension((String)result) + this.extension;
        }
        return result;
    }

    private String removeExtension(String fileName) {
        int index;
        String result = fileName;
        if (this.deleteExistingExtension && fileName != null && fileName.length() > 1 && (index = fileName.lastIndexOf(46)) != -1) {
            result = fileName.substring(0, index);
        }
        return result;
    }
}

