/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.planner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.planner.strategy.FilterStrategy;
import org.eclipse.swordfish.core.planner.strategy.Hint;
import org.eclipse.swordfish.core.util.ReadOnlyRegistry;
import org.eclipse.swordfish.internal.core.planner.PlannerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterStrategyImpl
implements FilterStrategy {
    private static final Log LOG = LogFactory.getLog(PlannerImpl.class);
    private List<FilterStrategy> filterStrategies;

    @Override
    public List<Interceptor> filter(List<Interceptor> interceptors, ReadOnlyRegistry<Interceptor> registry, List<Hint<?>> hints) {
        HashSet<Interceptor> filtered = new HashSet<Interceptor>();
        if (this.filterStrategies != null && this.filterStrategies.size() > 0) {
            for (FilterStrategy strategy : this.filterStrategies) {
                filtered.addAll(strategy.filter(interceptors, registry, hints));
            }
        } else {
            filtered.addAll(interceptors);
            LOG.info((Object)"No filter strategy defined");
        }
        return new ArrayList<Interceptor>(filtered);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    public void setFilterStrategies(List<FilterStrategy> filterStrategies) {
        this.filterStrategies = filterStrategies;
    }
}

