/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.util.xml;

import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.swordfish.internal.core.util.xml.StringSource;
import org.springframework.util.Assert;

public class XmlUtil {
    public static final String DEFAULT_CHARSET_PROPERTY = "org.apache.servicemix.default.charset";
    public static final String defaultCharset = System.getProperty("org.apache.servicemix.default.charset", "UTF-8");
    private static TransformerFactory transformerFactory;

    public static Transformer getTransformer() {
        Transformer ret;
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        Assert.notNull((Object)transformerFactory);
        try {
            ret = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        Assert.notNull((Object)ret);
        ret.setOutputProperty("encoding", defaultCharset);
        return ret;
    }

    public static String toString(Source source) {
        if (source == null) {
            return null;
        }
        if (source instanceof StringSource) {
            return ((StringSource)source).getText();
        }
        StringWriter buffer = new StringWriter();
        try {
            XmlUtil.getTransformer().transform(source, new StreamResult(buffer));
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
        return buffer.toString();
    }
}

