/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.integration.nmr;

import java.util.List;
import javax.jbi.messaging.MessageExchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.runtime.impl.MessageExchangeImpl;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.event.ExchangeListener;
import org.apache.servicemix.nmr.api.event.Listener;
import org.apache.servicemix.nmr.core.ExchangeImpl;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.SwordfishContext;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.core.event.Event;
import org.eclipse.swordfish.core.planner.Planner;
import org.eclipse.swordfish.core.util.Registry;
import org.eclipse.swordfish.internal.core.event.TrackingEventImpl;
import org.eclipse.swordfish.internal.core.exception.InterceptorExceptionNotificationSender;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwordfishExchangeListener
implements ExchangeListener,
InitializingBean {
    private static final transient Log LOG = LogFactory.getLog(SwordfishExchangeListener.class);
    private NMR nmr;
    private Planner planner;
    private Interceptor endpointResolverInterceptor;
    private Registry<Interceptor> interceptorRegistry;
    private InterceptorExceptionNotificationSender exceptionNotificationSender;
    private SwordfishContext swordfishContext;

    public Registry<Interceptor> getInterceptorRegistry() {
        return this.interceptorRegistry;
    }

    public void setInterceptorRegistry(Registry<Interceptor> interceptorRegistry) {
        this.interceptorRegistry = interceptorRegistry;
    }

    public void exchangeDelivered(Exchange exchange) {
        LOG.debug((Object)("ExchangeDelivered exchangeId=" + exchange.getId()));
    }

    public InterceptorExceptionNotificationSender getExceptionNotificationSender() {
        return this.exceptionNotificationSender;
    }

    public void setExceptionNotificationSender(InterceptorExceptionNotificationSender exceptionNotificationSender) {
        this.exceptionNotificationSender = exceptionNotificationSender;
    }

    public void exchangeSent(Exchange exchange) {
        MessageExchangeImpl exchangeImpl = new MessageExchangeImpl(exchange);
        try {
            block7: {
                this.sendTrackingEvent(exchangeImpl);
                try {
                    this.endpointResolverInterceptor.process((MessageExchange)exchangeImpl);
                }
                catch (SwordfishException ex) {
                    LOG.warn((Object)"The EndpointResolver has thrown exception", (Throwable)ex);
                    this.exceptionNotificationSender.sendNotification((Exception)((Object)ex), (MessageExchange)exchangeImpl, this.endpointResolverInterceptor);
                    exchangeImpl.setError((Exception)((Object)ex));
                    this.sendTrackingEvent(exchangeImpl);
                    if (exchangeImpl.getRole() != MessageExchange.Role.CONSUMER) break block7;
                    throw ex;
                }
            }
            List interceptors = this.planner.getInterceptorChain(this.interceptorRegistry.getKeySet(), (MessageExchange)exchangeImpl);
            for (Interceptor interceptor : interceptors) {
                try {
                    interceptor.process((MessageExchange)exchangeImpl);
                }
                catch (SwordfishException ex) {
                    LOG.warn((Object)"The interceptor has thrown exception", (Throwable)ex);
                    this.exceptionNotificationSender.sendNotification((Exception)((Object)ex), (MessageExchange)exchangeImpl, interceptor);
                    exchangeImpl.setError((Exception)((Object)ex));
                    this.sendTrackingEvent(exchangeImpl);
                    if (exchangeImpl.getRole() != MessageExchange.Role.CONSUMER) continue;
                    throw ex;
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void sendTrackingEvent(MessageExchangeImpl me) {
        InternalEventExchange eventExchange = new InternalEventExchange(me.getInternalExchange());
        MessageExchangeImpl eventMessageExchange = new MessageExchangeImpl((Exchange)eventExchange);
        TrackingEventImpl trackingEvent = new TrackingEventImpl((MessageExchange)eventMessageExchange);
        this.swordfishContext.getEventService().postEvent((Event)trackingEvent);
    }

    public NMR getNmr() {
        return this.nmr;
    }

    public void setNmr(NMR nmr) {
        this.nmr = nmr;
    }

    public Planner getPlanner() {
        return this.planner;
    }

    public void setPlanner(Planner planner) {
        this.planner = planner;
    }

    public Interceptor getEndpointResolverInterceptor() {
        return this.endpointResolverInterceptor;
    }

    public void setEndpointResolverInterceptor(Interceptor endpointResolverInterceptor) {
        this.endpointResolverInterceptor = endpointResolverInterceptor;
    }

    protected void start() {
        this.nmr.getListenerRegistry().register((Listener)this, null);
    }

    public void setSwordfishContext(SwordfishContext swordfishContext) {
        this.swordfishContext = swordfishContext;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.nmr);
        Assert.notNull((Object)this.planner);
        Assert.notNull(this.interceptorRegistry);
        Assert.notNull((Object)this.swordfishContext);
        this.start();
    }

    public void exchangeFailed(Exchange arg0) {
    }

    private class InternalEventExchange
    extends ExchangeImpl {
        private String exchangeId;

        public InternalEventExchange(Exchange exchange) {
            super(exchange.getPattern());
            this.exchangeId = exchange.getId();
            this.copyFrom(exchange);
            this.setOperation(exchange.getOperation());
            this.setStatus(exchange.getStatus());
        }

        public String getId() {
            return this.exchangeId;
        }
    }
}

