/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.interceptor;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Message;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Reference;
import org.apache.servicemix.nmr.api.Role;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.api.internal.InternalExchange;
import org.apache.servicemix.nmr.core.DynamicReference;
import org.apache.servicemix.nmr.core.InternalEndpointWrapper;
import org.apache.servicemix.nmr.core.util.Filter;
import org.apache.servicemix.soap.util.DomUtil;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.internal.core.util.ReflectionUtil;
import org.eclipse.swordfish.internal.core.util.smx.ServiceMixSupport;
import org.eclipse.swordfish.internal.core.util.xml.StringSource;
import org.eclipse.swordfish.internal.core.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfDecoratingInterceptor
implements Interceptor {
    private static final Log LOG = LogFactory.getLog(CxfDecoratingInterceptor.class);
    public static final String PROCESSED_BY_CXF_DECORATING_INTERCEPTOR = "PROCESSED_BY_CXF_DECORATING_INTERCEPTOR";
    private static final String SOAP_MESSAGE_PREFIX = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body>";
    private static final String SOAP_MESSAGE_SUFFIX = "</soap:Body></soap:Envelope>";
    private Map<String, Object> properties = new HashMap<String, Object>();
    private NMR nmr;

    public CxfDecoratingInterceptor() {
        QName interceptorType = new QName("http://interceptor.core.internal.swordfish.eclipse.org/", "CxfDecoratingInterceptor");
        this.properties.put("type", interceptorType);
    }

    public NMR getNmr() {
        return this.nmr;
    }

    public void setNmr(NMR nmr) {
        this.nmr = nmr;
    }

    public void process(MessageExchange exchange) throws SwordfishException {
        InternalExchange messageExchange = (InternalExchange)ServiceMixSupport.toNMRExchange((MessageExchange)exchange);
        if (messageExchange.getTarget() == null) {
            return;
        }
        InternalEndpoint endpoint = this.extractTargetEndpoint(messageExchange);
        if (!this.isCxfEndpoint(endpoint)) {
            return;
        }
        try {
            Message outMessage;
            Role role = messageExchange.getRole();
            if (role == Role.Consumer) {
                Message inMessage = messageExchange.getIn(false);
                this.wrapEnvelope(inMessage, (Exchange)messageExchange);
            } else if (role == Role.Provider && (outMessage = messageExchange.getOut(false)) != null) {
                this.unwrapEnvelope(outMessage, (Exchange)messageExchange);
            }
            if (messageExchange.getStatus() == Status.Active) {
                if (messageExchange.getFault(false) != null && messageExchange.getFault(false).getBody() == null) {
                    messageExchange.setFault(null);
                }
                if (messageExchange.getOut(false) != null && messageExchange.getOut(false).getBody() == null) {
                    messageExchange.setOut(null);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"An exception occured while trying to process exchange: ", (Throwable)e);
            throw new SwordfishException("An exception occured while trying to process exchange: ", (Throwable)e);
        }
    }

    private Map<String, ?> getTargetProperties(Reference target) {
        if (target == null || !(target instanceof DynamicReference)) {
            return null;
        }
        Filter filter = (Filter)ReflectionUtil.getDeclaredField((Object)target, DynamicReference.class, (String)"filter");
        if (filter == null) {
            return null;
        }
        List instanceVariables = ReflectionUtil.getAnonymousClassInstanceValues((Object)filter);
        if (instanceVariables.size() == 0) {
            return null;
        }
        if (instanceVariables.get(0) instanceof Map) {
            return (Map)instanceVariables.get(0);
        }
        return null;
    }

    private InternalEndpoint extractTargetEndpoint(InternalExchange messageExchange) {
        Map<String, ?> targetProps;
        Reference target = messageExchange.getTarget();
        InternalEndpoint endpoint = ServiceMixSupport.getEndpoint((NMR)this.nmr, (Reference)target);
        if (endpoint == null && (targetProps = this.getTargetProperties(target)) != null && targetProps.containsKey("jbi.internal")) {
            targetProps.remove("jbi.internal");
            try {
                Field field = DynamicReference.class.getDeclaredField("matches");
                field.setAccessible(true);
                field.set(target, null);
                endpoint = ServiceMixSupport.getEndpoint((NMR)this.nmr, (Reference)target);
            }
            catch (Exception ex) {
                LOG.warn((Object)"Couldn't extract an endpoint: ", (Throwable)ex);
            }
        }
        return endpoint;
    }

    private boolean isCxfEndpoint(InternalEndpoint endpoint) {
        if (endpoint == null) {
            return false;
        }
        try {
            InternalEndpointWrapper endpointWrapper = (InternalEndpointWrapper)endpoint;
            Field endpointField = InternalEndpointWrapper.class.getDeclaredField("endpoint");
            endpointField.setAccessible(true);
            Endpoint innerEndpoint = (Endpoint)endpointField.get(endpointWrapper);
            return innerEndpoint != null && innerEndpoint.getClass().getCanonicalName() != null && innerEndpoint.getClass().getCanonicalName().contains("cxf");
        }
        catch (Exception ex) {
            LOG.warn((Object)"Couldn't check an endpoint: ", (Throwable)ex);
            return false;
        }
    }

    private void wrapEnvelope(Message inMessage, Exchange messageExchange) {
        String message = XmlUtil.toString((Source)((Source)inMessage.getBody(Source.class)));
        if (!message.contains(":Body")) {
            int index = message.indexOf(">") + 1;
            String xmlPrefix = message.substring(0, index);
            String cutMessage = message.substring(index);
            message = String.valueOf(xmlPrefix) + SOAP_MESSAGE_PREFIX + cutMessage + SOAP_MESSAGE_SUFFIX;
            messageExchange.setProperty(PROCESSED_BY_CXF_DECORATING_INTERCEPTOR, (Object)true);
        }
        inMessage.setBody((Object)new StringSource(message));
    }

    private void unwrapEnvelope(Message outMessage, Exchange messageExchange) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        if (!messageExchange.getProperties().containsKey(PROCESSED_BY_CXF_DECORATING_INTERCEPTOR) || !((Boolean)messageExchange.getProperties().get(PROCESSED_BY_CXF_DECORATING_INTERCEPTOR)).booleanValue()) {
            return;
        }
        String message = XmlUtil.toString((Source)((Source)outMessage.getBody(Source.class)));
        if (message.contains(":Body")) {
            int index = message.indexOf(">") + 1;
            String xmlPrefix = message.substring(0, index);
            if (this.envelopeIsEmpty(message)) {
                Document document = DomUtil.createDocument();
                QName operation = messageExchange.getOperation();
                DomUtil.createElement((Node)document, (QName)new QName(operation.getNamespaceURI(), String.valueOf(operation.getLocalPart()) + "Response", operation.getPrefix()));
                outMessage.setBody((Object)new DOMSource(document));
                return;
            }
            String cutMessage = message.substring(index);
            int startIndex = cutMessage.indexOf(":Body");
            startIndex = cutMessage.indexOf(">", startIndex) + 1;
            int endIndex = cutMessage.indexOf(":Body", startIndex);
            endIndex = cutMessage.substring(0, endIndex).lastIndexOf("</");
            String bodyMessage = cutMessage.substring(startIndex, endIndex);
            bodyMessage = String.valueOf(xmlPrefix) + bodyMessage;
            outMessage.setBody((Object)new SourceTransformer().toDOMSource((Source)new StringSource(bodyMessage)));
        }
    }

    private boolean envelopeIsEmpty(String message) {
        return message.contains(":Body/>");
    }

    public Map<String, ?> getProperties() {
        return this.properties;
    }
}

