/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.plugins.cxf.support;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.servicemix.cxf.transport.nmr.NMRConduit;
import org.apache.servicemix.cxf.transport.nmr.NMRMessageHelper;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Pattern;
import org.apache.servicemix.nmr.api.Reference;
import org.apache.servicemix.nmr.api.Status;

public class NMROutputStream
extends CachedOutputStream {
    private static final Log LOG = LogFactory.getLog(NMROutputStream.class);
    private Message message;
    private boolean isOneWay;
    private Channel channel;
    private NMRConduit conduit;
    private EndpointReferenceType target;

    public NMROutputStream(Message m, NMR nmr, EndpointReferenceType target, NMRConduit conduit) {
        this.message = m;
        this.channel = nmr.createChannel();
        this.conduit = conduit;
        this.target = target;
    }

    protected void doFlush() throws IOException {
    }

    protected void doClose() throws IOException {
        this.isOneWay = this.message.getExchange().isOneWay();
        this.sendOutputMessage();
        if (this.target != null) {
            this.target.getClass();
        }
        this.channel.close();
    }

    protected void sendOutputMessage() throws IOException {
        try {
            org.apache.servicemix.nmr.api.Exchange xchng = this.createNMRMessageExchange();
            Source source = (Source)this.message.getContent(Source.class);
            String contentSrc = new SourceTransformer().toString(source);
            LOG.info((Object)("Sending message\n" + contentSrc));
            if (!this.isOneWay) {
                this.channel.sendSync(xchng);
                Source content = null;
                content = xchng.getFault(false) != null ? (Source)xchng.getFault().getBody(Source.class) : (Source)xchng.getOut().getBody(Source.class);
                MessageImpl inMessage = new MessageImpl();
                this.message.getExchange().setInMessage((Message)inMessage);
                InputStream ins = NMRMessageHelper.convertMessageToInputStream((Source)content);
                if (ins == null) {
                    throw new IOException("Unable to retrive message");
                }
                inMessage.setContent(InputStream.class, (Object)ins);
                this.conduit.getMessageObserver().onMessage((Message)inMessage);
                xchng.setStatus(Status.Done);
                this.channel.send(xchng);
            } else {
                this.channel.sendSync(xchng);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e.toString());
        }
    }

    private org.apache.servicemix.nmr.api.Exchange createNMRMessageExchange() throws IOException {
        Member member = (Member)this.message.get((Object)Method.class.getName());
        Class<?> clz = member.getDeclaringClass();
        Exchange exchange = this.message.getExchange();
        BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        LOG.info((Object)("Invoking service" + clz));
        WebService ws = clz.getAnnotation(WebService.class);
        InterfaceInfo info = (InterfaceInfo)this.message.getExchange().get(InterfaceInfo.class);
        QName interfaceName = null;
        if (ws != null && ws.name() != null && !"".equals(ws.name())) {
            interfaceName = new QName(ws.targetNamespace(), ws.name());
        } else if (info != null) {
            interfaceName = info.getName();
        }
        QName serviceName = this.target != null ? EndpointReferenceUtils.getServiceName((EndpointReferenceType)this.target, (Bus)this.conduit.getBus()) : ((Service)this.message.getExchange().get(Service.class)).getName();
        LOG.info((Object)("Create messageExchange" + serviceName));
        org.apache.servicemix.nmr.api.Exchange xchng = this.isOneWay ? this.channel.createExchange(Pattern.InOnly) : (bop.getOutput() == null ? this.channel.createExchange(Pattern.RobustInOnly) : this.channel.createExchange(Pattern.InOut));
        org.apache.servicemix.nmr.api.Message inMsg = xchng.getIn();
        LOG.info((Object)("Exchange endpoint " + serviceName));
        LOG.info((Object)("setup message contents on " + inMsg));
        inMsg.setBody((Object)this.getMessageContent(this.message));
        LOG.info((Object)("service for exchange " + serviceName));
        HashMap<String, String> refProps = new HashMap<String, String>();
        if (interfaceName != null) {
            refProps.put("INTERFACE_NAME", interfaceName.toString());
        }
        refProps.put("SERVICE_NAME", serviceName.toString());
        Reference ref = this.channel.getNMR().getEndpointRegistry().lookup(refProps);
        xchng.setTarget(ref);
        xchng.setOperation(bop.getName());
        return xchng;
    }

    private Source getMessageContent(Message message2) throws IOException {
        return new StreamSource(this.getInputStream());
    }

    protected void onWrite() throws IOException {
    }
}

