/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.plugins.planner.policy;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.servicemix.common.util.DOMUtil;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Role;
import org.eclipse.swordfish.core.planner.strategy.Hint;
import org.eclipse.swordfish.core.planner.strategy.HintExtractor;
import org.eclipse.swordfish.core.resolver.policy.PolicyExtractor;
import org.eclipse.swordfish.internal.core.util.smx.ServiceMixSupport;
import org.eclipse.swordfish.plugins.planner.policy.AssertionHint;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyAssertionHintExtractor
implements HintExtractor {
    public static final String ENDPOINT_METADAT_PROPERTY = "org.eclipse.swordfish.core.resolver.EndpointMetadata";
    private static final Log LOG = LogFactory.getLog(PolicyAssertionHintExtractor.class);
    private static final List<Hint<?>> EMPTY_LIST = Collections.emptyList();
    private PolicyExtractor policyExtractor;

    public PolicyExtractor getPolicyExtractor() {
        return this.policyExtractor;
    }

    public void setPolicyExtractor(PolicyExtractor policyExtractor) {
        this.policyExtractor = policyExtractor;
    }

    public List<Hint<?>> extractHints(MessageExchange messageExchange) {
        Policy policy = this.getPolicy(messageExchange);
        return policy != null ? this.extractAssertions(policy) : EMPTY_LIST;
    }

    private Policy getPolicy(MessageExchange messageExchange) {
        Policy policy;
        block6: {
            DocumentFragment policyFragment;
            block8: {
                Map headers;
                block7: {
                    policy = null;
                    Exchange exchange = ServiceMixSupport.toNMRExchange((MessageExchange)messageExchange);
                    if (exchange.getRole() != Role.Consumer) break block6;
                    headers = (Map)exchange.getIn().getHeader("org.apache.servicemix.soap.headers");
                    if (headers != null) break block7;
                    return null;
                }
                policyFragment = (DocumentFragment)headers.get(new QName("http://eclipse.org/swordfish/headers", "Policy"));
                if (policyFragment == null) {
                    for (Object key : headers.keySet()) {
                        if (!(key instanceof QName) || !((QName)key).getLocalPart().equals("Policy")) continue;
                        policyFragment = (DocumentFragment)headers.get(key);
                    }
                }
                if (policyFragment != null) break block8;
                return null;
            }
            try {
                Element policyElement = (Element)policyFragment.getFirstChild();
                String source = DOMUtil.asXML((Node)policyElement);
                return this.policyExtractor.extractPolicy((InputStream)new ByteArrayInputStream(source.getBytes("UTF8")));
            }
            catch (Exception ex) {
                LOG.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return policy;
    }

    public List<Hint<?>> extractAssertions(Policy policy) {
        ArrayList assertions = new ArrayList();
        Iterator alternativesIter = policy.getAlternatives();
        if (alternativesIter.hasNext()) {
            Iterable alternative = (Iterable)alternativesIter.next();
            for (Assertion assertion : alternative) {
                assertions.add(new AssertionHint<Assertion>(assertion));
            }
        }
        return assertions;
    }
}

