/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.plugins.planner.policy;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.planner.strategy.FilterStrategy;
import org.eclipse.swordfish.core.planner.strategy.Hint;
import org.eclipse.swordfish.core.util.ReadOnlyRegistry;
import org.eclipse.swordfish.plugins.planner.policy.AssertionHint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyBasedFilterStrategy
implements FilterStrategy {
    private static final Log LOG = LogFactory.getLog(PolicyBasedFilterStrategy.class);

    public List<Interceptor> filter(List<Interceptor> interceptors, ReadOnlyRegistry<Interceptor> registry, List<Hint<?>> hints) {
        ArrayList<Interceptor> validInterceptors = new ArrayList<Interceptor>();
        Iterable<AssertionHint<?>> assertionHints = this.filterAssertionHints(hints);
        LOG.info((Object)("Filtering the interceptors with the followng list of policy based hints: " + assertionHints));
        for (Interceptor interceptor : interceptors) {
            if (this.oneSupports(assertionHints, interceptor, registry)) {
                LOG.info((Object)("Adding interceptor " + interceptor + " to the list of valid interceptors."));
                validInterceptors.add(interceptor);
                continue;
            }
            LOG.info((Object)("Dropped interceptor " + interceptor + " from the list of valid interceptors."));
        }
        return validInterceptors;
    }

    private Iterable<AssertionHint<?>> filterAssertionHints(Iterable<Hint<?>> hints) {
        ArrayList assertionHints = new ArrayList();
        for (Hint<?> hint : hints) {
            if (!AssertionHint.class.isAssignableFrom(hint.getClass())) continue;
            assertionHints.add((AssertionHint)AssertionHint.class.cast(hint));
        }
        return assertionHints;
    }

    private boolean oneSupports(Iterable<AssertionHint<?>> hints, Interceptor interceptor, ReadOnlyRegistry<Interceptor> registry) {
        for (AssertionHint<?> hint : hints) {
            if (!hint.supportsInterceptor(interceptor, registry)) continue;
            LOG.debug((Object)("Hint " + hint + " accepted interceptor " + interceptor + "."));
            return true;
        }
        return false;
    }

    public int getPriority() {
        return 0;
    }
}

