/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.registry.InMemoryRepository;
import org.eclipse.swordfish.registry.PolicyResource;
import org.eclipse.swordfish.registry.domain.Definition;
import org.eclipse.swordfish.registry.domain.PortType;
import org.eclipse.swordfish.registry.domain.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryRepositoryImpl
implements InMemoryRepository {
    private static final Log LOGGER = LogFactory.getLog(InMemoryRepositoryImpl.class);
    private MultiMap<QName, Definition> portTypeWSDLs = new MultiMap();
    private Map<String, Definition> wsdlDefinitions = new HashMap<String, Definition>();
    private Map<String, PolicyResource> policies = new HashMap<String, PolicyResource>();

    @Override
    public Iterable<Definition> getWSDLDefinitionsByPortType(QName portTypeName) {
        return this.portTypeWSDLs.get(portTypeName);
    }

    @Override
    public Iterable<Definition> getWSDLDefinitionsByServiceReferencingPortType(QName portTypeName) {
        HashSet<Definition> wsdlDefinitions = new HashSet<Definition>();
        Iterable<PortType> portTypes = this.getPortTypes(portTypeName);
        for (PortType portType : portTypes) {
            for (Service service : portType.getServices()) {
                wsdlDefinitions.add(service.getWSDL());
            }
        }
        return wsdlDefinitions;
    }

    public Iterable<PortType> getPortTypes(QName portTypeName) {
        HashSet<PortType> result = new HashSet<PortType>();
        Iterable<Definition> wsdls = this.portTypeWSDLs.get(portTypeName);
        for (Definition wsdl : wsdls) {
            result.add(wsdl.getPortType(portTypeName));
        }
        return result;
    }

    @Override
    public Definition getWSDLDefinitionById(String id) {
        return this.wsdlDefinitions.get(id);
    }

    @Override
    public Iterable<Definition> getAllWSDLDefinitions() {
        return this.wsdlDefinitions.values();
    }

    @Override
    public PolicyResource getPolicy(String id) {
        return this.policies.get(id);
    }

    @Override
    public Iterable<PortType> getAllPortTypes() {
        HashSet<PortType> allPortTypes = new HashSet<PortType>();
        Iterable<Definition> wsdlresources = this.portTypeWSDLs.values();
        for (Definition wsdlResource : wsdlresources) {
            for (PortType portType : wsdlResource.getAllPortTypes()) {
                allPortTypes.add(portType);
            }
        }
        return allPortTypes;
    }

    @Override
    public void registerPortTypeWSDL(QName portTypeName, Definition wsdl) {
        this.portTypeWSDLs.put(portTypeName, wsdl);
    }

    @Override
    public void deregisterPortTypeWSDL(QName portTypeName, Definition wsdl) {
        this.portTypeWSDLs.remove(portTypeName, wsdl);
    }

    @Override
    public void registerWSDLDefinition(String id, Definition wsdlDefinition) {
        this.wsdlDefinitions.put(id, wsdlDefinition);
    }

    @Override
    public void deregisterWSDLDefinition(String id) {
        this.wsdlDefinitions.remove(id);
    }

    @Override
    public void registerPolicy(PolicyResource policy) {
        this.policies.put(policy.getId(), policy);
    }

    @Override
    public void deregisterPolicy(PolicyResource policy) {
        this.policies.remove(policy.getId());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultiMap<K, V> {
        private Map<K, Set<V>> multiMap = new HashMap<K, Set<V>>();

        public void put(K key, V value) {
            Set<V> values = this.multiMap.get(key);
            if (values == null) {
                values = new HashSet<V>();
                this.multiMap.put(key, values);
            }
            values.add(value);
        }

        public void remove(K key, V value) {
            Set<V> values = this.multiMap.get(key);
            if (values != null) {
                values.remove(value);
            }
        }

        public void remove(V value) {
            for (Set<V> values : this.multiMap.values()) {
                values.remove(value);
            }
        }

        public Iterable<V> get(K key) {
            Set<V> values = this.multiMap.get(key);
            if (values != null) {
                return values;
            }
            return Collections.emptySet();
        }

        public Iterable<K> keys() {
            return this.multiMap.keySet();
        }

        public Iterable<V> values() {
            HashSet<V> result = new HashSet<V>();
            Collection<Set<V>> valueSets = this.multiMap.values();
            for (Set<V> set : valueSets) {
                result.addAll(set);
            }
            return result;
        }
    }
}

