/*******************************************************************************
 * Copyright (c) 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.helper;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

public class TemplateProcessor {
	private InputStream stream;
	private Map<String, String> templateSubstituteMapping;
	
	/**
	 * Create a processor
	 * @param stream input document stream
	 * @param templateSubstituteMapping template
	 */
	public TemplateProcessor(InputStream stream, Map<String, String> templateSubstituteMapping) {
		this.stream = stream;
		this.templateSubstituteMapping = templateSubstituteMapping;
	}
	
	
	/**
	 * Process the source stream and return the result.
	 * 
	 * @throws	IOException  if exception during writing 
	 * @return stream of result document
	 */	
	public InputStream process() throws IOException {
		String template = streamToString(stream);
		SimpleTemplateProcessor processor = new SimpleTemplateProcessor(template, templateSubstituteMapping);
		return new ByteArrayInputStream(processor.process().getBytes());
	}

	
	private String streamToString(InputStream stream) throws IOException {
		StringBuilder sb = new StringBuilder();
		BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
		
		int c;
		try {
			c = reader.read();
			while (c > -1) {
				sb.append((char) c);
				c = reader.read();
			}
		} finally {
			reader.close();
		}
		
		return sb.toString();
	}
}
