/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.helper;

import java.util.List;
import java.util.Map;

import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;

import org.apache.cxf.jaxb.JAXBUtils;

public class Wsdl4jModel implements ServiceModel {

	static private WSDLFactory wsdlFactory;
	Definition definition = null;
	String locationUri = null;
	String soapPortType = null;

	@SuppressWarnings("unchecked")
	public Wsdl4jModel(String pathToWsdl) {

		if (null == wsdlFactory) {
			try {
				wsdlFactory = WSDLFactory.newInstance();
			} catch (WSDLException e) {
				throw new RuntimeException("Could not create WsdlModel.", e);
			}
		}
		WSDLReader wr = wsdlFactory.newWSDLReader();
		try {
			definition = wr.readWSDL(pathToWsdl);
			if (definition.getAllServices().isEmpty()) {
				throw new IllegalArgumentException(
						"WSDL document does not contain a service element.");
			}
			Service service = getFirstService();
			Map<String, Port> ports = (Map<String, Port>) service.getPorts();
			for (Port port : ports.values()) {
				List<ExtensibilityElement> elements = port
						.getExtensibilityElements();
				for (ExtensibilityElement element : elements) {
					if (element instanceof SOAPAddress) {
						locationUri = ((SOAPAddress) element).getLocationURI();
						soapPortType = getLocalPortTypeName(port);
						break;
					}
					if (element instanceof SOAP12Address) {
						locationUri = ((SOAP12Address) element)
								.getLocationURI();
						soapPortType = getLocalPortTypeName(port);
						break;
					}
				}
				if (locationUri != null) {
					break;
				}
			}
			if (locationUri == null) {
				throw new IllegalArgumentException(
						"WSDL document does not contain a SOAP port.");
			}

		} catch (WSDLException e) {
			throw new IllegalArgumentException("WSDL document is invalid.", e);
		}
	}

	public String getTargetNamespace() {
		return definition.getTargetNamespace();
	}

	public String getServiceName() {
		return getFirstService().getQName().getLocalPart();
	}

	public String getImplementorClass() {
		return JAXBUtils.namespaceURIToPackage(getTargetNamespace()) + "."
				+ capitalize(getServiceName());
	}

	private String capitalize(String str) {
		return str.substring(0, 1).toUpperCase() + str.substring(1);
	}

	public String getServiceUrl() {
		return locationUri;
	}

	public String getSoapPortType() {
		return soapPortType;
	}

	@SuppressWarnings("unchecked")
	private Service getFirstService() {
		Map<QName, Service> services = (Map<QName, Service>) definition
				.getServices();
		return services.values().iterator().next();
	}
	
	private String getLocalPortTypeName(Port p) throws WSDLException {
		String portType = null;
		Binding b = p.getBinding();
		
		if (b != null) {
			PortType pt = b.getPortType();
			
			if (pt != null) {
				portType = pt.getQName().getLocalPart();
			} else {
				throw new WSDLException(WSDLException.INVALID_WSDL, "Could not port type for binding " + b.getQName());
			}
		} else {
			throw new WSDLException(WSDLException.INVALID_WSDL, "Could not find binding for port " + p.getName());
		}
		
		return portType;
	}
}