/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards;

import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.ui.templates.ITemplateSection;
import org.eclipse.pde.ui.templates.NewPluginTemplateWizard;

/**
 * class PluginContentWizard
 * 
 * @author amarkevich
 */
public class PluginContentWizard extends NewPluginTemplateWizard {

	private static final IPluginReference[] DEPENDENCIES = {
		//new PluginReference("javax.xml.ws", null, 0),
		//new PluginReference("org.apache.cxf.cxf-bundle", null, 0),
		//new PluginReference("org.apache.servicemix.cxf.transport.nmr", null, 0),
		//new PluginReference("servicemixhttp", null, 0),
		//new PluginReference("javax.jws", null, 0),
	};

	private static final String[] IMPORT_PACKAGES = {
		//"com.sun.xml.bind.v2",
		"javax.wsdl",
		"org.apache.servicemix.nmr.api",
		"org.springframework.beans.factory.config",
		"org.apache.servicemix.common.osgi",
		"javax.jws",
		"javax.xml.ws",
		"META-INF.cxf",
		//"META-INF.cxf.transport.nmr",
		"META-INF.org.eclipse.swordfish.plugins.cxf.support",
	};
	
	/**
	 * {@inheritDoc}
	 */
	public ITemplateSection[] createTemplateSections() {
        return new ITemplateSection[] {new PluginContentWizardSection()};
	}

	@Override
	public IPluginReference[] getDependencies(String schemaVersion) {
		return DEPENDENCIES.clone();
	}
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String[] getImportPackages() {
		return IMPORT_PACKAGES.clone(); 
	}

}
