/*******************************************************************************
 * Copyright (c) 2008, 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards;

/**
 * class TemplateConstants
 * 
 * @author amarkevich
 */
public interface TemplateConstants {

	/**
	 * The key for the service name used in templates
	 * (value="some.wsdl").
	 */
	String WSDL_FILE_NAME = "some.wsdl";

	/**
	 * The key for the service name used in templates
	 * (value="serviceName").
	 */
	String KEY_SERVICE_NAME = "serviceName";

	/**
	 * The key for the service ID used in templates
	 * (value="serviceId").
	 */
	String KEY_SERVICE_ID = "serviceId";

	/**
	 * The key for the service implementor class package used in templates
	 * (value="servicePackage").
	 */
	String KEY_SERVICE_PACKAGE = "servicePackage";

	/**
	 * The key for the service implementor interface used in templates
	 * (value="serviceInterface").
	 */
	String KEY_SERVICE_INTERFACE = "serviceInterface";

	/**
	 * The key for the service implementor class name used in templates
	 * (value="serviceImpl").
	 */
	String KEY_SERVICE_IMPL = "serviceImpl";
	
	/**
	 * The key for the name of the service implementation (port type) used in templates
	 * (value="serviceImplInstance").
	 */
	String KEY_SERVICE_IMPL_INSTANCE = "serviceImplInstance";

	/**
	 * The key for the service target namespace used in templates
	 * (value="serviceTargetNamespace").
	 */
	String KEY_SERVICE_TARGET_NAMESPACE = "serviceTargetNamespace";
	
	/**
	 * The key for the service url used in templates
	 * (value="serviceURL").
	 */
	String KEY_SERVICE_URL = "serviceURL";

	/**
	 * The key for open comment "<!--"
	 * (value="openComment").
	 */
	String KEY_OPEN_COMMENT = "openComment";

	/**
	 * The key for close comment "<--"
	 * (value="openComment").
	 */
	String KEY_CLOSE_COMMENT = "closeComment";

	/**
	 * The key for the list of consumer jaxws client entries
	 * (value="consumerClientList").
	 */
	String KEY_CLIENT_REFS = "consumerClientList";

	/**
	 * The key for the list of spring property consumer jaxws client entries
	 * (value="consumerSpringProperties").
	 */
	String KEY_CLIENT_SPRING_REFS = "consumerSpringProperties";
}
