/*******************************************************************************
 * Copyright (c) 2009 SOPERA GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SOPERA GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.swordfish.tooling.ui.wizards.generators.data;

import org.w3c.dom.Element;

/**
 * Contains the original cxf spring client element found in a consumer spring configuration
 * and allows for easy access to the most important attributes.
 */
public class JaxWsClientInformation {
	public static final String SERVICE_CLASS = "serviceClass";
	public static final String CLIENT_ID = "id";
	
	private Element jaxWsClientElement;
	private String serviceNamespace;

	public Element getJaxWsClientElement() {
		return jaxWsClientElement;
	}
	
	public void setJaxWsClientElement(Element jaxWsClientElement) {
		this.jaxWsClientElement = jaxWsClientElement;
	}
	
	public String getServiceNamespace() {
		return serviceNamespace;
	}
	
	public void setServiceNamespace(String serviceNamespace) {
		this.serviceNamespace = serviceNamespace;
	}

	private String getElementAttribute(String attributeName) {
		return (jaxWsClientElement != null) ? jaxWsClientElement.getAttribute(attributeName) : null;		
	}
	
	/**
	 * @return the qualified name of the service class
	 */
	public String getServiceClassAttribute() {
		return getElementAttribute(SERVICE_CLASS);
	}
	
	/**
	 * @return the unqualified name of the service class
	 */
	public String getServiceClass() {
		return extractClassOrPackage(getElementAttribute(SERVICE_CLASS), true);
	}
	
	/**
	 * @return the package of the service class
	 */
	public String getServiceClassPackage() {
		return extractClassOrPackage(getElementAttribute(SERVICE_CLASS), false);
	}
	
	
	/**
	 * Extract simple class name or package name from a fully qualified class name
	 * @param fullyQualifiedClass - the fully qualified class name
	 * @param doExtractClass - decides whether the class name (true) or the package name (false) should be returned
	 * @return 
	 */
	String extractClassOrPackage(String fullyQualifiedClass, boolean doExtractClass) {
		String result = "";
		int classPos = 0;
		
		if (fullyQualifiedClass != null) {
			classPos = fullyQualifiedClass.lastIndexOf('.');
			result = (classPos > 0) ? fullyQualifiedClass.substring(0, classPos) : "";
			
		} else if (fullyQualifiedClass == null) {
			return null;
		}
		
		return (doExtractClass ? fullyQualifiedClass.substring(classPos + 1) : result) ;
	}
	
	
	/**
	 * @return the client id (id attribute of the client element).
	 */
	public String getClientID() {
		return getElementAttribute(CLIENT_ID);
	}

	@Override
	public String toString() {
		return "JaxWsClientInformation [getClientID()=" + getClientID()
				+ ", getServiceClassAttribute()=" + getServiceClassAttribute()
				+ ", getJaxWsClientElement()=" + getJaxWsClientElement() + "]";
	}
}
