/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.core.CollectionFactory;

public abstract class AbstractApplicationEventMulticaster
implements ApplicationEventMulticaster {
    private Collection applicationListeners = new LinkedHashSet();

    public void setConcurrentUpdates(boolean concurrent) {
        Set newColl = concurrent ? CollectionFactory.createCopyOnWriteSet() : new LinkedHashSet();
        newColl.addAll(this.applicationListeners);
        this.applicationListeners = newColl;
    }

    public void setCollectionClass(Class collectionClass) {
        if (collectionClass == null) {
            throw new IllegalArgumentException("'collectionClass' must not be null");
        }
        if (!Collection.class.isAssignableFrom(collectionClass)) {
            throw new IllegalArgumentException("'collectionClass' must implement [java.util.Collection]");
        }
        Collection newColl = (Collection)BeanUtils.instantiateClass((Class)collectionClass);
        newColl.addAll(this.applicationListeners);
        this.applicationListeners = newColl;
    }

    public void addApplicationListener(ApplicationListener listener) {
        this.applicationListeners.add(listener);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        this.applicationListeners.remove(listener);
    }

    public void removeAllListeners() {
        this.applicationListeners.clear();
    }

    protected Collection getApplicationListeners() {
        return this.applicationListeners;
    }
}

