/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.internal.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.service.ServiceUnavailableException;
import org.springframework.osgi.service.importer.ImportedOsgiServiceProxy;
import org.springframework.osgi.service.importer.OsgiServiceLifecycleListener;
import org.springframework.osgi.service.importer.internal.aop.ServiceProxyCreator;
import org.springframework.osgi.service.importer.internal.collection.CollectionProxy;
import org.springframework.osgi.service.importer.internal.collection.DynamicCollection;
import org.springframework.osgi.service.importer.internal.util.OsgiServiceBindingUtils;
import org.springframework.osgi.util.OsgiListenerUtils;
import org.springframework.util.Assert;

public class OsgiServiceCollection
implements Collection,
InitializingBean,
CollectionProxy,
DisposableBean {
    private static final Log log = LogFactory.getLog((Class)OsgiServiceCollection.class);
    protected final Map servicesIdMap = new LinkedHashMap(8);
    protected DynamicCollection serviceProxies;
    protected volatile Object tailDeadProxy;
    private boolean serviceRequiredAtStartup = true;
    private final Filter filter;
    private final BundleContext context;
    private final ClassLoader classLoader;
    private final ServiceProxyCreator proxyCreator;
    private OsgiServiceLifecycleListener[] listeners = new OsgiServiceLifecycleListener[0];
    private final ServiceListener listener;

    public OsgiServiceCollection(Filter filter, BundleContext context, ClassLoader classLoader, ServiceProxyCreator proxyCreator) {
        Assert.notNull((Object)classLoader, (String)"ClassLoader is required");
        Assert.notNull((Object)context, (String)"context is required");
        this.filter = filter;
        this.context = context;
        this.classLoader = classLoader;
        this.proxyCreator = proxyCreator;
        this.listener = new Listener();
    }

    public void afterPropertiesSet() {
        this.serviceProxies = this.createInternalDynamicStorage();
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("adding osgi listener for services matching [" + this.filter + "]"));
        }
        OsgiListenerUtils.addServiceListener(this.context, this.listener, this.filter);
        if (this.serviceRequiredAtStartup) {
            if (trace) {
                log.trace((Object)("1..x cardinality - looking for service [" + this.filter + "] at startup..."));
            }
            this.mandatoryServiceCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        OsgiListenerUtils.removeServiceListener(this.context, this.listener);
        DynamicCollection dynamicCollection = this.serviceProxies;
        synchronized (dynamicCollection) {
            Iterator iterator = this.serviceProxies.iterator();
            while (iterator.hasNext()) {
                ImportedOsgiServiceProxy serviceProxy = (ImportedOsgiServiceProxy)iterator.next();
                this.listener.serviceChanged(new ServiceEvent(4, serviceProxy.getServiceReference()));
            }
            this.serviceProxies.clear();
        }
        this.servicesIdMap.clear();
    }

    protected void mandatoryServiceCheck() {
        if (this.serviceRequiredAtStartup && this.serviceProxies.isEmpty()) {
            throw new ServiceUnavailableException(this.filter);
        }
    }

    public boolean isSatisfied() {
        if (this.serviceRequiredAtStartup) {
            return this.serviceProxies.isEmpty();
        }
        return true;
    }

    protected DynamicCollection createInternalDynamicStorage() {
        return new DynamicCollection();
    }

    private void invalidateProxy(Object proxy) {
    }

    protected void checkDeadProxies(Object proxy, int proxyCollectionPos) {
        if (proxyCollectionPos == this.serviceProxies.size() - 1) {
            this.tailDeadProxy = proxy;
        }
    }

    private void checkDeadProxies(Object proxy) {
        int index = this.serviceProxies.indexOf(proxy);
        this.checkDeadProxies(proxy, index);
    }

    public Iterator iterator() {
        return new OsgiServiceIterator();
    }

    public int size() {
        this.mandatoryServiceCheck();
        return this.serviceProxies.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.mandatoryServiceCheck();
        DynamicCollection dynamicCollection = this.serviceProxies;
        synchronized (dynamicCollection) {
            return this.serviceProxies.toString();
        }
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object o) {
        this.mandatoryServiceCheck();
        return this.serviceProxies.contains(o);
    }

    public boolean containsAll(Collection c) {
        this.mandatoryServiceCheck();
        return this.serviceProxies.containsAll(c);
    }

    public boolean isEmpty() {
        this.mandatoryServiceCheck();
        return this.size() == 0;
    }

    public Object[] toArray() {
        this.mandatoryServiceCheck();
        return this.serviceProxies.toArray();
    }

    public Object[] toArray(Object[] array) {
        this.mandatoryServiceCheck();
        return this.serviceProxies.toArray(array);
    }

    public void setListeners(OsgiServiceLifecycleListener[] listeners) {
        Assert.notNull((Object)listeners, (String)"argument should not be null");
        this.listeners = listeners;
    }

    public void setRequiredAtStartup(boolean serviceRequiredAtStartup) {
        this.serviceRequiredAtStartup = serviceRequiredAtStartup;
    }

    private class Listener
    implements ServiceListener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void serviceChanged(ServiceEvent event) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(OsgiServiceCollection.this.classLoader);
                ServiceReference ref = event.getServiceReference();
                Long serviceId = (Long)ref.getProperty("service.id");
                boolean collectionModified = false;
                Object proxy = null;
                switch (event.getType()) {
                    case 1: 
                    case 2: {
                        DynamicCollection dynamicCollection = OsgiServiceCollection.this.serviceProxies;
                        synchronized (dynamicCollection) {
                            if (!OsgiServiceCollection.this.servicesIdMap.containsKey(serviceId) && OsgiServiceCollection.this.serviceProxies.add(proxy = OsgiServiceCollection.this.proxyCreator.createServiceProxy(ref))) {
                                collectionModified = true;
                                OsgiServiceCollection.this.servicesIdMap.put(serviceId, proxy);
                            }
                        }
                        if (!collectionModified) return;
                        OsgiServiceBindingUtils.callListenersBind(OsgiServiceCollection.this.context, proxy, ref, OsgiServiceCollection.this.listeners);
                        return;
                    }
                    case 4: {
                        DynamicCollection dynamicCollection = OsgiServiceCollection.this.serviceProxies;
                        synchronized (dynamicCollection) {
                            proxy = OsgiServiceCollection.this.servicesIdMap.remove(serviceId);
                            if (proxy != null) {
                                OsgiServiceCollection.this.checkDeadProxies(proxy);
                                collectionModified = OsgiServiceCollection.this.serviceProxies.remove(proxy);
                                OsgiServiceCollection.this.invalidateProxy(proxy);
                            }
                        }
                        if (!collectionModified) return;
                        OsgiServiceBindingUtils.callListenersUnbind(OsgiServiceCollection.this.context, proxy, ref, OsgiServiceCollection.this.listeners);
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported event type:" + event);
                    }
                }
            }
            catch (Throwable re) {
                if (!log.isWarnEnabled()) return;
                log.warn((Object)"serviceChanged() processing failed", re);
                return;
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
    }

    protected class OsgiServiceIterator
    implements Iterator {
        private final Iterator iter;

        protected OsgiServiceIterator() {
            this.iter = OsgiServiceCollection.this.serviceProxies.iterator();
        }

        public boolean hasNext() {
            OsgiServiceCollection.this.mandatoryServiceCheck();
            return this.iter.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            DynamicCollection dynamicCollection = OsgiServiceCollection.this.serviceProxies;
            synchronized (dynamicCollection) {
                OsgiServiceCollection.this.mandatoryServiceCheck();
                Object proxy = this.iter.next();
                return proxy == null ? OsgiServiceCollection.this.tailDeadProxy : proxy;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

