/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.osgi.service.importer.internal.aop.ImportedOsgiServiceProxyAdvice;
import org.springframework.osgi.service.importer.internal.aop.ServiceProxyCreator;
import org.springframework.osgi.service.importer.internal.aop.ServiceTCCLInterceptor;
import org.springframework.osgi.service.importer.support.ImportContextClassLoader;
import org.springframework.osgi.service.importer.support.LocalBundleContextAdvice;
import org.springframework.osgi.util.DebugUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.osgi.util.internal.ClassUtils;
import org.springframework.util.Assert;

abstract class AbstractServiceProxyCreator
implements ServiceProxyCreator {
    private static final Log log = LogFactory.getLog((Class)AbstractServiceProxyCreator.class);
    private final Advice clientTCCLAdvice;
    private final Advice invokerBundleContextAdvice;
    protected final ClassLoader classLoader;
    protected final Class[] classes;
    protected final BundleContext bundleContext;
    private final ImportContextClassLoader iccl;

    AbstractServiceProxyCreator(Class[] classes, ClassLoader classLoader, BundleContext bundleContext, ImportContextClassLoader iccl) {
        Assert.notNull((Object)bundleContext);
        Assert.notNull((Object)classLoader);
        this.classes = classes;
        this.bundleContext = bundleContext;
        this.classLoader = classLoader;
        this.iccl = iccl;
        this.clientTCCLAdvice = new ServiceTCCLInterceptor(classLoader);
        this.invokerBundleContextAdvice = new LocalBundleContextAdvice(bundleContext);
    }

    public Object createServiceProxy(ServiceReference reference) {
        ArrayList<ImportedOsgiServiceProxyAdvice> advices = new ArrayList<ImportedOsgiServiceProxyAdvice>(4);
        ImportedOsgiServiceProxyAdvice mixin = new ImportedOsgiServiceProxyAdvice(reference);
        advices.add(mixin);
        advices.add((ImportedOsgiServiceProxyAdvice)this.invokerBundleContextAdvice);
        Advice tcclAdvice = this.determineTCCLAdvice(reference);
        if (tcclAdvice != null) {
            advices.add((ImportedOsgiServiceProxyAdvice)tcclAdvice);
        }
        advices.add((ImportedOsgiServiceProxyAdvice)this.createDispatcherInterceptor(reference));
        return this.createProxy(this.getInterfaces(reference), this.classLoader, this.bundleContext, advices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Advice determineTCCLAdvice(ServiceReference reference) {
        try {
            if (ImportContextClassLoader.CLIENT == this.iccl) {
                Advice advice = this.clientTCCLAdvice;
                return advice;
            }
            if (ImportContextClassLoader.SERVICE_PROVIDER == this.iccl) {
                Advice advice = this.createServiceProviderTCCLAdvice(reference);
                return advice;
            }
            if (ImportContextClassLoader.UNMANAGED == this.iccl) {
                Advice advice = null;
                return advice;
            }
            Advice advice = null;
            return advice;
        }
        finally {
            if (log.isTraceEnabled()) {
                log.trace((Object)((Object)((Object)this.iccl) + " TCCL used for invoking " + OsgiStringUtils.nullSafeToString(reference)));
            }
        }
    }

    private Object createProxy(Class[] classes, ClassLoader classLoader, BundleContext bundleContext, List advices) {
        ProxyFactory factory = new ProxyFactory();
        ClassUtils.configureFactoryForClass(factory, classes);
        Iterator iterator = advices.iterator();
        while (iterator.hasNext()) {
            Advice advice = (Advice)iterator.next();
            factory.addAdvice(advice);
        }
        factory.setFrozen(true);
        try {
            return factory.getProxy(classLoader);
        }
        catch (NoClassDefFoundError ncdfe) {
            DebugUtils.debugClassLoadingThrowable(ncdfe, bundleContext.getBundle(), classes);
            throw ncdfe;
        }
    }

    Class[] getInterfaces(ServiceReference reference) {
        return this.classes;
    }

    abstract Advice createServiceProviderTCCLAdvice(ServiceReference var1);

    abstract Advice createDispatcherInterceptor(ServiceReference var1);
}

