/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.marker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.marker.AbstractBaseChartPaintListener;
import org.eclipse.swtchart.extensions.marker.IBaseChartPaintListener;

public class LabelMarker
extends AbstractBaseChartPaintListener
implements IBaseChartPaintListener {
    private Map<Integer, String> labels = new HashMap<Integer, String>();
    private int indexSeries = -1;
    private ISeries<?> serie;
    private int orientation;

    public LabelMarker(BaseChart baseChart) {
        super(baseChart);
    }

    public void setLabels(List<String> labels, int indexSeries, int orientation) {
        HashMap<Integer, String> labelsMap = new HashMap<Integer, String>();
        int index = 0;
        for (String label : labels) {
            labelsMap.put(index++, label);
        }
        this.setLabels(labelsMap, indexSeries, orientation);
    }

    public void setLabels(Map<Integer, String> labels, int indexSeries, int orientation) {
        this.setSeriesIndex(indexSeries);
        this.setLabels(labels, orientation);
    }

    public void setLabels(Map<Integer, String> labels, int orientation) {
        this.orientation = orientation;
        this.labels = labels != null ? labels : new HashMap();
    }

    public void setSeriesIndex(int indexSeries) {
        this.indexSeries = indexSeries;
    }

    public void setSeries(ISeries serie) {
        this.serie = serie;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void clear() {
        this.labels.clear();
    }

    public void paintControl(PaintEvent e) {
        ISeries serie = this.getSeries();
        if (serie == null) {
            return;
        }
        BaseChart baseChart = this.getBaseChart();
        IPlotArea plotArea = baseChart.getPlotArea();
        Rectangle rectangle = plotArea instanceof Scrollable ? ((Scrollable)plotArea).getClientArea() : plotArea.getBounds();
        int size = serie.getXSeries().length;
        Transform oldTransform = new Transform(e.gc.getDevice());
        e.gc.getTransform(oldTransform);
        float[] fs = new float[6];
        oldTransform.getElements(fs);
        Transform textTransform = new Transform(e.gc.getDevice());
        e.gc.setForeground(e.gc.getDevice().getSystemColor(2));
        try {
            for (int index : this.labels.keySet()) {
                String label;
                if (index >= size || (label = this.labels.get(index)) == null || label.isEmpty()) continue;
                Point point = serie.getPixelCoordinates(index);
                if (point.x <= 0 || !rectangle.contains(point)) continue;
                Point labelSize = e.gc.textExtent(label);
                int x = point.x - labelSize.y / 2;
                int y = point.y - 15;
                GC gc = e.gc;
                textTransform.setElements(fs[0], fs[1], fs[2], fs[3], fs[4], fs[5]);
                textTransform.translate((float)x, (float)y);
                if (this.orientation == 512) {
                    textTransform.rotate(-90.0f);
                }
                gc.setTransform(textTransform);
                gc.drawText(label, 0, 0, true);
            }
        }
        finally {
            e.gc.setTransform(oldTransform);
            oldTransform.dispose();
            textTransform.dispose();
        }
    }

    protected ISeries getSeries() {
        if (this.serie != null) {
            return this.serie;
        }
        ISeries[] series = this.getBaseChart().getSeriesSet().getSeries();
        if (this.indexSeries >= 0 && this.indexSeries < series.length) {
            return series[this.indexSeries];
        }
        return null;
    }
}

