/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.text.DecimalFormat;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;

public abstract class AbstractAxisSettings
implements IAxisSettings {
    private String title = "";
    private boolean titleVisible;
    private String description = "";
    private DecimalFormat decimalFormat;
    private Color color;
    private Font titleFont;
    private boolean visible;
    private IAxis.Position position;
    private Color gridColor;
    private LineStyle gridLineStyle;
    private boolean enableLogScale;
    private boolean reversed;
    private int extraSpaceTitle;
    private final Font defaultFont = new Font((Device)Display.getDefault(), "Tahoma", 11, 1);

    public AbstractAxisSettings(String title) {
        this(title, title);
    }

    public AbstractAxisSettings(String title, String description) {
        this.title = title;
        this.description = description;
        this.titleVisible = true;
        this.decimalFormat = new DecimalFormat();
        this.color = Display.getDefault().getSystemColor(2);
        this.titleFont = this.defaultFont;
        this.visible = true;
        this.position = IAxis.Position.Primary;
        this.gridColor = Display.getDefault().getSystemColor(15);
        this.gridLineStyle = LineStyle.DOT;
        this.enableLogScale = false;
        this.reversed = false;
        this.extraSpaceTitle = 25;
    }

    @Override
    public String getLabel() {
        String label = "";
        if (this.title.equals("")) {
            label = this.description.equals("") ? "label not set" : this.description;
        } else if (this.description.equals("")) {
            label = this.title;
        } else {
            label = this.description;
            if (this instanceof IPrimaryAxisSettings && (this.description.equals("X-Axis") || this.description.equals("Y-Axis"))) {
                label = this.title;
            }
        }
        return label;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isTitleVisible() {
        return this.titleVisible;
    }

    @Override
    public void setTitleVisible(boolean titleVisible) {
        this.titleVisible = titleVisible;
    }

    @Override
    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    @Override
    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Font getTitleFont() {
        return this.titleFont;
    }

    @Override
    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public IAxis.Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(IAxis.Position position) {
        this.position = position;
    }

    @Override
    public Color getGridColor() {
        return this.gridColor;
    }

    @Override
    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    @Override
    public LineStyle getGridLineStyle() {
        return this.gridLineStyle;
    }

    @Override
    public void setGridLineStyle(LineStyle gridLineStyle) {
        this.gridLineStyle = gridLineStyle;
    }

    @Override
    public boolean isEnableLogScale() {
        return this.enableLogScale;
    }

    @Override
    public void setEnableLogScale(boolean enableLogScale) {
        this.enableLogScale = enableLogScale;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public int getExtraSpaceTitle() {
        return this.extraSpaceTitle;
    }

    @Override
    public void setExtraSpaceTitle(int extraSpaceTitle) {
        this.extraSpaceTitle = extraSpaceTitle;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.defaultFont.isDisposed()) {
            this.defaultFont.dispose();
        }
    }
}

