/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.core.AbstractHandledChart;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.IChartDataCoordinates;
import org.eclipse.swtchart.extensions.core.IExtendedChart;
import org.eclipse.swtchart.extensions.core.IRangeSupport;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.exceptions.SeriesException;

public abstract class AbstractExtendedChart
extends AbstractHandledChart
implements IChartDataCoordinates,
IRangeSupport,
IExtendedChart {
    private int seriesMaxDataPoints;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private RangeRestriction rangeRestriction;
    private double extendedMinX;
    private double extendedMaxX;
    private double extendedMinY;
    private double extendedMaxY;
    private Map<Integer, IAxisSettings> xAxisSettingsMap = new HashMap<Integer, IAxisSettings>();
    private Map<Integer, IAxisSettings> yAxisSettingsMap = new HashMap<Integer, IAxisSettings>();
    private Map<String, ISeriesSettings> seriesSettingsMap = new HashMap<String, ISeriesSettings>();

    public AbstractExtendedChart(Composite parent, int style) {
        super(parent, style);
        this.resetCoordinates();
    }

    @Override
    public int getSeriesMaxDataPoints() {
        return this.seriesMaxDataPoints;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public RangeRestriction getRangeRestriction() {
        return this.rangeRestriction;
    }

    @Override
    public void setRangeRestriction(RangeRestriction rangeRestriction) {
        this.rangeRestriction = rangeRestriction;
    }

    public IAxisSettings getXAxisSettings(int index) {
        return this.xAxisSettingsMap.get(index);
    }

    public IAxisSettings getYAxisSettings(int index) {
        return this.yAxisSettingsMap.get(index);
    }

    public void putXAxisSettings(int key, IAxisSettings axisSettings) {
        this.xAxisSettingsMap.put(key, axisSettings);
    }

    public void removeXAxisSettings() {
        Set<Integer> keySet = this.xAxisSettingsMap.keySet();
        HashSet<Integer> removeKeys = new HashSet<Integer>();
        for (int key : keySet) {
            if (key == 0) continue;
            removeKeys.add(key);
        }
        for (int key : removeKeys) {
            this.xAxisSettingsMap.remove(key);
        }
    }

    public void putYAxisSettings(int key, IAxisSettings axisSettings) {
        this.yAxisSettingsMap.put(key, axisSettings);
    }

    public void removeYAxisSettings() {
        Set<Integer> keySet = this.yAxisSettingsMap.keySet();
        HashSet<Integer> removeKeys = new HashSet<Integer>();
        for (int key : keySet) {
            if (key == 0) continue;
            removeKeys.add(key);
        }
        for (int key : removeKeys) {
            this.yAxisSettingsMap.remove(key);
        }
    }

    public ISeriesSettings getSeriesSettings(String id) {
        return this.seriesSettingsMap.get(id);
    }

    @Override
    public void setRange(IAxis axis, int xStart, int xStop, boolean adjustMinMax) {
        if (axis != null && Math.abs(xStop - xStart) > 0 && !this.isUpdateSuspended()) {
            double start = axis.getDataCoordinate(Math.min(xStart, xStop));
            double stop = axis.getDataCoordinate(Math.max(xStart, xStop));
            this.setRange(axis, start, stop, adjustMinMax);
        }
    }

    @Override
    public void setRange(IAxis axis, double start, double stop, boolean adjustMinMax) {
        if (axis != null && Math.abs(stop - start) > 0.0 && !this.isUpdateSuspended()) {
            double min = Math.min(start, stop);
            double max = Math.max(start, stop);
            axis.setRange(new Range(min, max));
            if (adjustMinMax) {
                this.adjustMinMaxRange(axis);
            }
            if (axis.getDirection() == IAxis.Direction.X) {
                this.adjustSecondaryXAxes();
            } else if (axis.getDirection() == IAxis.Direction.Y) {
                this.adjustSecondaryYAxes();
            }
        }
    }

    @Override
    public void adjustMinMaxRange(IAxis axis) {
        if (axis != null && !this.isUpdateSuspended()) {
            Range range = axis.getRange();
            if (axis.getDirection().equals((Object)IAxis.Direction.X)) {
                range.lower = this.rangeRestriction.isZeroX() ? (range.lower < 0.0 ? 0.0 : range.lower) : (range.lower < this.minX ? this.minX : range.lower);
                this.extendRange("X_AXIS", range, this.extendedMinX, this.extendedMaxX, this.rangeRestriction.getExtendMinX(), this.rangeRestriction.getExtendMaxX());
            } else {
                range.lower = this.rangeRestriction.isForceZeroMinY() ? 0.0 : (this.rangeRestriction.isZeroY() ? (range.lower < 0.0 ? 0.0 : range.lower) : (range.lower < this.minY ? this.minY : range.lower));
                this.extendRange("Y_AXIS", range, this.extendedMinY, this.extendedMaxY, this.rangeRestriction.getExtendMinY(), this.rangeRestriction.getExtendMaxY());
            }
            if (range.lower < range.upper) {
                axis.setRange(range);
            }
        }
    }

    private void extendRange(String axis, Range range, double min, double max, double extendMin, double extendMax) {
        double lowerExtension = this.getExtensionValue(axis, range.lower, extendMin);
        double upperExtension = this.getExtensionValue(axis, range.upper, extendMax);
        if (lowerExtension != 0.0) {
            if (range.lower != min) {
                double lowerCalculated = range.lower > 0.0 ? range.lower - lowerExtension : range.lower + lowerExtension;
                range.lower = lowerCalculated <= min ? min : (range.lower < min ? min : range.lower);
            }
        } else {
            double d = range.lower = range.lower < min ? min : range.lower;
        }
        if (upperExtension != 0.0) {
            if (range.upper != max) {
                double upperCalculated = range.upper > 0.0 ? range.upper + upperExtension : range.upper - upperExtension;
                range.upper = upperCalculated >= max ? max : (range.upper > max ? max : range.upper);
            }
        } else {
            range.upper = range.upper > max ? max : range.upper;
        }
    }

    @Override
    public ISeries createSeries(ISeriesData seriesData, ISeriesSettings seriesSettings) throws SeriesException {
        double[] ySeries;
        ISeries.SeriesType seriesType = this.getSeriesType(seriesSettings);
        double[] xSeries = seriesData.getXSeries();
        if (xSeries.length == (ySeries = seriesData.getYSeries()).length) {
            String id = seriesData.getId();
            this.seriesSettingsMap.put(id, seriesSettings);
            ISeriesSet seriesSet = this.getSeriesSet();
            ISeries series = seriesSet.createSeries(seriesType, id);
            series.setXSeries(xSeries);
            series.setYSeries(ySeries);
            this.calculateCoordinates(series);
            return series;
        }
        throw new SeriesException("The length of x and y series differs.");
    }

    @Override
    public void deleteSeries(String id) {
        ISeriesSet seriesSet = this.getSeriesSet();
        if (seriesSet.getSeries(id) != null) {
            this.resetCoordinates();
            seriesSet.deleteSeries(id);
            this.seriesSettingsMap.remove(id);
            ISeries[] iSeriesArray = seriesSet.getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries series = iSeriesArray[n2];
                this.calculateCoordinates(series);
                ++n2;
            }
        }
    }

    @Override
    public void appendSeries(ISeriesData seriesData) {
        ISeriesSet seriesSet;
        ISeries series;
        if (seriesData != null && (series = (seriesSet = this.getSeriesSet()).getSeries(seriesData.getId())) != null) {
            double[] xSeriesNew = this.concatenateSeries(series.getXSeries(), seriesData.getXSeries());
            series.setXSeries(xSeriesNew);
            double[] ySeriesNew = this.concatenateSeries(series.getYSeries(), seriesData.getYSeries());
            series.setYSeries(ySeriesNew);
            this.calculateCoordinates(series);
        }
    }

    protected boolean isRangeValid(Range range) {
        return !Double.isNaN(range.lower) && !Double.isNaN(range.upper);
    }

    private ISeries.SeriesType getSeriesType(ISeriesSettings seriesSettings) {
        ISeries.SeriesType seriesType = ISeries.SeriesType.LINE;
        if (seriesSettings instanceof IBarSeriesSettings) {
            seriesType = ISeries.SeriesType.BAR;
        }
        return seriesType;
    }

    private double[] concatenateSeries(double[] a, double[] b) {
        int length = a.length + b.length;
        double[] c = new double[length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    @Override
    public void setRange(String axis, double start, double stop) {
        IAxisSet axisSet = this.getAxisSet();
        IAxis selectedAxis = axis.equals("X_AXIS") ? axisSet.getXAxis(0) : axisSet.getYAxis(0);
        this.setRange(selectedAxis, start, stop, true);
    }

    @Override
    public void adjustRange(boolean adjustMinMax) {
        if (!this.isUpdateSuspended()) {
            this.getAxisSet().adjustRange();
            if (adjustMinMax) {
                this.adjustMinMaxRange(this.getAxisSet().getXAxis(0));
                this.adjustMinMaxRange(this.getAxisSet().getYAxis(0));
            }
            this.adjustSecondaryXAxes();
            this.adjustSecondaryYAxes();
        }
    }

    public void adjustSecondaryAxes() {
        this.adjustSecondaryXAxes();
        this.adjustSecondaryYAxes();
    }

    @Override
    public void adjustSecondaryXAxes() {
        IAxisSet axisSet = this.getAxisSet();
        IAxis xAxis = axisSet.getXAxis(0);
        Range range = xAxis.getRange();
        int[] nArray = axisSet.getXAxisIds();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            if (id != 0) {
                IAxis axis = axisSet.getXAxis(id);
                IAxisSettings axisSettings = this.xAxisSettingsMap.get(id);
                if (axis != null && axisSettings instanceof ISecondaryAxisSettings) {
                    IAxisScaleConverter axisScaleConverter = ((ISecondaryAxisSettings)axisSettings).getAxisScaleConverter();
                    axisScaleConverter.setChartDataCoordinates(this);
                    double start = axisScaleConverter.convertToSecondaryUnit(range.lower);
                    double end = axisScaleConverter.convertToSecondaryUnit(range.upper);
                    if (end > start) {
                        Range adjustedRange = new Range(start, end);
                        axis.setRange(adjustedRange);
                    } else {
                        System.out.println("Can't set secondary x axes range: " + start + "\t" + end);
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public void adjustSecondaryYAxes() {
        IAxisSet axisSet = this.getAxisSet();
        IAxis yAxis = axisSet.getYAxis(0);
        Range range = yAxis.getRange();
        int[] nArray = axisSet.getYAxisIds();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            if (id != 0) {
                IAxis axis = axisSet.getYAxis(id);
                IAxisSettings axisSettings = this.yAxisSettingsMap.get(id);
                if (axis != null && axisSettings instanceof ISecondaryAxisSettings) {
                    Range adjustedRange;
                    IAxisScaleConverter axisScaleConverter = ((ISecondaryAxisSettings)axisSettings).getAxisScaleConverter();
                    axisScaleConverter.setChartDataCoordinates(this);
                    double start = axisScaleConverter.convertToSecondaryUnit(range.lower);
                    double end = axisScaleConverter.convertToSecondaryUnit(range.upper);
                    if (end > start && this.isRangeValid(adjustedRange = new Range(start, end))) {
                        axis.setRange(adjustedRange);
                    }
                }
            }
            ++n2;
        }
    }

    private void resetCoordinates() {
        this.seriesMaxDataPoints = 0;
        this.minX = Double.POSITIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        this.minY = Double.POSITIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
    }

    private void calculateCoordinates(ISeries series) {
        double[] xSeries = series.getXSeries();
        double[] ySeries = series.getYSeries();
        if (xSeries.length != 0) {
            double seriesMinX = Arrays.stream(xSeries).min().getAsDouble();
            double seriesMaxX = Arrays.stream(xSeries).max().getAsDouble();
            double seriesMinY = Arrays.stream(ySeries).min().getAsDouble();
            double seriesMaxY = Arrays.stream(ySeries).max().getAsDouble();
            this.seriesMaxDataPoints = Math.max(this.seriesMaxDataPoints, xSeries.length);
            this.updateCoordinates(seriesMinX, seriesMaxX, seriesMinY, seriesMaxY);
        }
    }

    protected void updateCoordinates(double seriesMinX, double seriesMaxX, double seriesMinY, double seriesMaxY) {
        this.minX = Math.min(this.minX, seriesMinX);
        this.minX = this.rangeRestriction.isZeroX() && this.minX < 0.0 ? 0.0 : this.minX;
        this.maxX = Math.max(this.maxX, seriesMaxX);
        this.minY = Math.min(this.minY, seriesMinY);
        this.minY = this.rangeRestriction.isZeroY() && this.minY < 0.0 ? 0.0 : this.minY;
        this.minY = this.rangeRestriction.isForceZeroMinY() ? 0.0 : this.minY;
        this.maxY = Math.max(this.maxY, seriesMaxY);
        this.calculateExtendedCoordinates();
    }

    private void calculateExtendedCoordinates() {
        this.extendedMinX = this.minX;
        double extensionValue = this.getExtensionValue("X_AXIS", this.extendedMinX, this.rangeRestriction.getExtendMinX());
        this.extendedMinX = this.extendedMinX > 0.0 ? (this.extendedMinX -= extensionValue) : (this.extendedMinX += extensionValue);
        this.extendedMaxX = this.maxX;
        extensionValue = this.getExtensionValue("X_AXIS", this.extendedMaxX, this.rangeRestriction.getExtendMaxX());
        this.extendedMaxX = this.extendedMaxX > 0.0 ? (this.extendedMaxX += extensionValue) : (this.extendedMaxX -= extensionValue);
        this.extendedMinY = this.minY;
        extensionValue = this.getExtensionValue("Y_AXIS", this.extendedMinY, this.rangeRestriction.getExtendMinY());
        this.extendedMinY = this.extendedMinY > 0.0 ? (this.extendedMinY -= extensionValue) : (this.extendedMinY += extensionValue);
        this.extendedMaxY = this.maxY;
        extensionValue = this.getExtensionValue("Y_AXIS", this.extendedMaxY, this.rangeRestriction.getExtendMaxY());
        this.extendedMaxY = this.extendedMaxY > 0.0 ? (this.extendedMaxY += extensionValue) : (this.extendedMaxY -= extensionValue);
    }

    private double getExtensionValue(String axis, double base, double extend) {
        RangeRestriction.ExtendType extendType = "X_AXIS".equals(axis) ? this.rangeRestriction.getExtendTypeX() : this.rangeRestriction.getExtendTypeY();
        double extensionValue = 0.0;
        switch (extendType) {
            case RELATIVE: {
                extensionValue = base * extend;
                break;
            }
            case ABSOLUTE: {
                extensionValue = extend;
            }
        }
        return extensionValue;
    }
}

