/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.series;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.StreamSupport;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IDisposeListener;
import org.eclipse.swtchart.IErrorBar;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesLabel;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.internal.axis.Axis;
import org.eclipse.swtchart.internal.compress.ICompress;
import org.eclipse.swtchart.internal.series.ErrorBar;
import org.eclipse.swtchart.internal.series.SeriesLabel;
import org.eclipse.swtchart.internal.series.SeriesSet;
import org.eclipse.swtchart.model.CartesianSeriesModel;
import org.eclipse.swtchart.model.DateArraySeriesModel;
import org.eclipse.swtchart.model.DoubleArraySeriesModel;
import org.eclipse.swtchart.model.IndexedSeriesModel;

public abstract class Series<T>
implements ISeries<T> {
    protected static final ISeries.SeriesType DEFAULT_SERIES_TYPE = ISeries.SeriesType.LINE;
    protected String id;
    protected ICompress compressor;
    protected int xAxisId;
    protected int yAxisId;
    protected boolean visible;
    protected ISeries.SeriesType type;
    protected SeriesLabel seriesLabel;
    protected ErrorBar xErrorBar;
    protected ErrorBar yErrorBar;
    protected Chart chart;
    protected boolean stackEnabled;
    protected double[] stackSeries;
    private boolean visibleInLegend;
    private String description;
    private List<IDisposeListener> listeners;
    private CartesianSeriesModel<T> model;

    protected Series(Chart chart, String id) {
        this.chart = chart;
        this.id = id;
        this.xAxisId = 0;
        this.yAxisId = 0;
        this.visible = true;
        this.type = DEFAULT_SERIES_TYPE;
        this.stackEnabled = false;
        this.seriesLabel = new SeriesLabel();
        this.xErrorBar = new ErrorBar();
        this.yErrorBar = new ErrorBar();
        this.visibleInLegend = true;
        this.listeners = new ArrayList<IDisposeListener>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        ((SeriesSet)this.chart.getSeriesSet()).updateStackAndRiserData();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public ISeries.SeriesType getType() {
        return this.type;
    }

    @Override
    public boolean isStackEnabled() {
        return this.stackEnabled;
    }

    @Override
    public CartesianSeriesModel<T> getDataModel() {
        return this.model;
    }

    @Override
    public void setDataModel(CartesianSeriesModel<T> model) {
        IAxis axis;
        this.model = model;
        this.setCompressor();
        this.compressor.setXSeries(this.getXSeries());
        this.compressor.setYSeries(this.getYSeries());
        Range xRange = this.getXRange();
        if (xRange.lower <= 0.0 && (axis = this.chart.getAxisSet().getXAxis(this.xAxisId)) != null) {
            axis.enableLogScale(false);
        }
        Range yRange = this.getYRange();
        if (yRange.lower <= 0.0) {
            IAxis axis2 = this.chart.getAxisSet().getYAxis(this.yAxisId);
            if (axis2 != null) {
                axis2.enableLogScale(false);
            }
            this.stackEnabled = false;
        }
    }

    @Override
    public void enableStack(boolean enabled) {
        Number minY = this.getDataModel().getMinY();
        if (enabled && minY != null && minY.doubleValue() < 0.0) {
            throw new IllegalStateException("Stacked series cannot contain minus values.");
        }
        if (this.stackEnabled == enabled) {
            return;
        }
        this.stackEnabled = enabled;
        ((SeriesSet)this.chart.getSeriesSet()).updateStackAndRiserData();
    }

    @Override
    public void setXSeries(double[] series) {
        if (series == null) {
            SWT.error((int)4);
            return;
        }
        double[] xSeries = new double[series.length];
        System.arraycopy(series, 0, xSeries, 0, series.length);
        double[] ySeries = this.getYSeries();
        if (ySeries.length != xSeries.length) {
            ySeries = new double[xSeries.length];
        }
        DoubleArraySeriesModel arraySeriesModel = new DoubleArraySeriesModel(xSeries, ySeries);
        this.setDataModel((CartesianSeriesModel<T>)arraySeriesModel);
    }

    @Override
    public void setXDateSeries(Date[] series) {
        double[] ySeries = this.getYSeries();
        if (ySeries.length != series.length) {
            ySeries = new double[series.length];
        }
        this.setDataModel((CartesianSeriesModel<T>)new DateArraySeriesModel(series, ySeries));
    }

    @Override
    public Date[] getXDateSeries() {
        CartesianSeriesModel dataModel = this.getDataModel();
        if (dataModel == null) {
            return new Date[0];
        }
        return (Date[])StreamSupport.stream(dataModel.spliterator(), false).filter(t -> dataModel.getX(t) != null).map(value -> new Date(dataModel.getX(value).longValue())).toArray(Date[]::new);
    }

    @Override
    public double[] getXSeries() {
        CartesianSeriesModel dataModel = this.getDataModel();
        if (dataModel == null) {
            return new double[0];
        }
        return StreamSupport.stream(dataModel.spliterator(), false).filter(t -> dataModel.getX(t) != null).mapToDouble(value -> dataModel.getX(value).doubleValue()).toArray();
    }

    @Override
    public void setYSeries(double[] series) {
        if (series == null) {
            SWT.error((int)4);
            return;
        }
        double[] xSeries = this.getXSeries();
        double[] ySeries = new double[series.length];
        System.arraycopy(series, 0, ySeries, 0, series.length);
        if (ySeries.length != xSeries.length) {
            xSeries = new double[ySeries.length];
            int i = 0;
            while (i < xSeries.length) {
                xSeries[i] = i;
                ++i;
            }
        }
        DoubleArraySeriesModel arraySeriesModel = new DoubleArraySeriesModel(xSeries, ySeries);
        this.setDataModel((CartesianSeriesModel<T>)arraySeriesModel);
    }

    @Override
    public double[] getYSeries() {
        CartesianSeriesModel dataModel = this.getDataModel();
        if (dataModel == null) {
            return new double[0];
        }
        return StreamSupport.stream(dataModel.spliterator(), false).filter(t -> dataModel.getY(t) != null).mapToDouble(value -> dataModel.getY(value).doubleValue()).toArray();
    }

    public boolean isValidStackSeries() {
        return this.stackEnabled && this.stackSeries != null && this.stackSeries.length > 0 && !this.chart.getAxisSet().getYAxis(this.yAxisId).isLogScaleEnabled() && ((Axis)this.chart.getAxisSet().getXAxis(this.xAxisId)).isValidCategoryAxis();
    }

    public Range getXRange() {
        double minX = 0.0;
        double maxX = 0.0;
        CartesianSeriesModel<T> dataModel = this.getDataModel();
        if (dataModel != null) {
            Number number = dataModel.getMinX();
            minX = number == null ? 0.0 : number.doubleValue();
            number = dataModel.getMaxX();
            maxX = number == null ? 0.0 : number.doubleValue();
        }
        return new Range(minX, maxX);
    }

    public abstract Range getAdjustedRange(Axis var1, int var2);

    public Range getYRange() {
        double min = 0.0;
        double max = 0.0;
        CartesianSeriesModel<T> dataModel = this.getDataModel();
        if (dataModel != null) {
            Number number = dataModel.getMinY();
            min = number == null ? 0.0 : number.doubleValue();
            number = dataModel.getMaxY();
            max = number == null ? 0.0 : number.doubleValue();
        }
        Axis xAxis = (Axis)this.chart.getAxisSet().getXAxis(this.xAxisId);
        if (this.isValidStackSeries() && xAxis.isValidCategoryAxis()) {
            int i = 0;
            while (i < this.stackSeries.length) {
                if (max < this.stackSeries[i]) {
                    max = this.stackSeries[i];
                }
                ++i;
            }
        }
        return new Range(min, max);
    }

    protected ICompress getCompressor() {
        return this.compressor;
    }

    protected abstract void setCompressor();

    @Override
    public int getXAxisId() {
        return this.xAxisId;
    }

    @Override
    public void setXAxisId(int id) {
        if (this.xAxisId == id) {
            return;
        }
        IAxis axis = this.chart.getAxisSet().getXAxis(this.xAxisId);
        if (this.getXRange().lower <= 0.0 && axis != null && axis.isLogScaleEnabled()) {
            this.chart.getAxisSet().getXAxis(this.xAxisId).enableLogScale(false);
        }
        this.xAxisId = id;
        ((SeriesSet)this.chart.getSeriesSet()).updateStackAndRiserData();
    }

    @Override
    public int getYAxisId() {
        return this.yAxisId;
    }

    @Override
    public void setYAxisId(int id) {
        this.yAxisId = id;
    }

    @Override
    public ISeriesLabel getLabel() {
        return this.seriesLabel;
    }

    @Override
    public IErrorBar getXErrorBar() {
        return this.xErrorBar;
    }

    @Override
    public IErrorBar getYErrorBar() {
        return this.yErrorBar;
    }

    protected void setStackSeries(double[] stackSeries) {
        this.stackSeries = stackSeries;
    }

    @Override
    public Point getPixelCoordinates(int index) {
        IAxis vAxis;
        IAxis hAxis;
        if (this.chart.getOrientation() == 256) {
            hAxis = this.chart.getAxisSet().getXAxis(this.xAxisId);
            vAxis = this.chart.getAxisSet().getYAxis(this.yAxisId);
        } else if (this.chart.getOrientation() == 512) {
            hAxis = this.chart.getAxisSet().getYAxis(this.yAxisId);
            vAxis = this.chart.getAxisSet().getXAxis(this.xAxisId);
        } else {
            throw new IllegalStateException("unknown chart orientation");
        }
        return new Point(this.getPixelCoordinate(hAxis, index), this.getPixelCoordinate(vAxis, index));
    }

    private int getPixelCoordinate(IAxis axis, int index) {
        CartesianSeriesModel dataModel = this.getDataModel();
        if (dataModel instanceof IndexedSeriesModel) {
            double dataCoordinate;
            IndexedSeriesModel indexedModel = (IndexedSeriesModel)((Object)dataModel);
            if (axis.getDirection() == IAxis.Direction.X) {
                if (axis.isCategoryEnabled()) {
                    dataCoordinate = index;
                } else {
                    if (index < 0 || indexedModel.size() <= index) {
                        throw new IllegalArgumentException("Series index is out of range.");
                    }
                    dataCoordinate = dataModel.getX(indexedModel.itemAt(index)).doubleValue();
                }
            } else if (axis.getDirection() == IAxis.Direction.Y) {
                if (this.isValidStackSeries()) {
                    if (index < 0 || this.stackSeries.length <= index) {
                        throw new IllegalArgumentException("Series index is out of range.");
                    }
                    dataCoordinate = this.stackSeries[index];
                } else {
                    if (index < 0 || indexedModel.size() <= index) {
                        throw new IllegalArgumentException("Series index is out of range.");
                    }
                    dataCoordinate = dataModel.getY(indexedModel.itemAt(index)).doubleValue();
                }
            } else {
                throw new IllegalStateException("unknown axis direction");
            }
            return axis.getPixelCoordinate(dataCoordinate);
        }
        throw new IllegalStateException("This requires a IndexedSeriesModel");
    }

    protected Range getRangeWithMargin(int lowerPlotMargin, int upperPlotMargin, int length, Axis axis, Range range) {
        if (length == 0) {
            return range;
        }
        int lowerPixelCoordinate = axis.getPixelCoordinate(range.lower, range.lower, range.upper) + lowerPlotMargin * (axis.isHorizontalAxis() && !axis.isReversed() ? -1 : 1);
        int upperPixelCoordinate = axis.getPixelCoordinate(range.upper, range.lower, range.upper) + upperPlotMargin * (axis.isHorizontalAxis() && !axis.isReversed() ? 1 : -1);
        double lower = axis.getDataCoordinate(lowerPixelCoordinate, range.lower, range.upper);
        double upper = axis.getDataCoordinate(upperPixelCoordinate, range.lower, range.upper);
        return new Range(lower, upper);
    }

    @Override
    public void setVisibleInLegend(boolean visible) {
        this.visibleInLegend = visible;
    }

    @Override
    public boolean isVisibleInLegend() {
        return this.visibleInLegend;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void dispose() {
        for (IDisposeListener listener : this.listeners) {
            listener.disposed(new Event());
        }
    }

    @Override
    public void addDisposeListener(IDisposeListener listener) {
        this.listeners.add(listener);
    }

    public void draw(GC gc, int width, int height) {
        if (!this.visible || width < 0 || height < 0) {
            return;
        }
        Axis xAxis = (Axis)this.chart.getAxisSet().getXAxis(this.getXAxisId());
        Axis yAxis = (Axis)this.chart.getAxisSet().getYAxis(this.getYAxisId());
        if (xAxis == null || yAxis == null) {
            return;
        }
        this.draw(gc, width, height, xAxis, yAxis);
    }

    protected abstract void draw(GC var1, int var2, int var3, Axis var4, Axis var5);
}

