/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.internal.categories;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.ICountable;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.internal.expressions.CountExpression;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.handler.CategoryAddToContributionItem;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategorizable;

public class CategoryPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IStructuredSelection) {
            return this.testSelection((IStructuredSelection)receiver, property, args, expectedValue);
        }
        return this.internalTest(receiver, property, args, expectedValue);
    }

    protected boolean testSelection(IStructuredSelection selection, String property, Object[] args, Object expectedValue) {
        Assert.isNotNull((Object)selection);
        if ("parentCategoryId".equals(property) && !selection.isEmpty()) {
            TreePath[] pathes;
            Object element = selection.getFirstElement();
            TreePath[] treePathArray = pathes = selection instanceof ITreeSelection ? ((ITreeSelection)selection).getPathsFor(element) : null;
            if (pathes != null) {
                TreePath[] treePathArray2 = pathes;
                int n = pathes.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath path = treePathArray2[n2];
                    TreePath parentPath = path.getParentPath();
                    while (parentPath != null) {
                        Object lastSegment = parentPath.getLastSegment();
                        if (lastSegment instanceof ICategory && ((ICategory)lastSegment).getId().equals(expectedValue)) {
                            return true;
                        }
                        parentPath = parentPath.getParentPath();
                    }
                    ++n2;
                }
            }
        }
        if ("validAddToCategoriesCount".equals(property)) {
            String value;
            CategoryAddToContributionItem item = new CategoryAddToContributionItem();
            ICategory[] categories = item.getCategories(selection, true);
            final int count = categories.length;
            String string = expectedValue instanceof String ? (String)expectedValue : (value = expectedValue != null ? expectedValue.toString() : null);
            if (value != null) {
                EvaluationResult result;
                block9: {
                    CountExpression expression = new CountExpression(value);
                    EvaluationContext context = new EvaluationContext(null, (Object)new ICountable(){

                        public int count() {
                            return count;
                        }
                    });
                    result = EvaluationResult.FALSE;
                    try {
                        result = expression.evaluate((IEvaluationContext)context);
                    }
                    catch (CoreException e) {
                        if (!Platform.inDebugMode()) break block9;
                        e.printStackTrace();
                    }
                }
                return result.equals(EvaluationResult.TRUE);
            }
        }
        return false;
    }

    protected boolean internalTest(Object receiver, String property, Object[] args, Object expectedValue) {
        String id;
        ICategorizable categorizable;
        ICategorizable iCategorizable = categorizable = receiver instanceof IAdaptable ? (ICategorizable)((IAdaptable)receiver).getAdapter(ICategorizable.class) : null;
        if (categorizable == null) {
            categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter(receiver, ICategorizable.class);
        }
        if ("belongsTo".equals(property) && categorizable != null && (id = categorizable.getId()) != null && expectedValue instanceof String) {
            return Managers.getCategoryManager().belongsTo((String)expectedValue, id);
        }
        if ("isCategoryID".equals(property) && receiver instanceof ICategory) {
            id = ((ICategory)receiver).getId();
            return id.equals(expectedValue);
        }
        return false;
    }
}

