/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.ScannerRunnable;
import org.eclipse.tcf.te.tcf.locator.interfaces.IScanner;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;

public class Scanner
extends Job
implements IScanner {
    private final ILocatorModel parentModel;
    private final Map<String, Object> configuration = new HashMap<String, Object>();
    private AtomicBoolean terminated = new AtomicBoolean(false);

    public Scanner(ILocatorModel parentModel) {
        super(Scanner.class.getName());
        Assert.isNotNull((Object)parentModel);
        this.parentModel = parentModel;
    }

    protected ILocatorModel getParentModel() {
        return this.parentModel;
    }

    @Override
    public void setConfiguration(Map<String, Object> configuration) {
        Assert.isNotNull(configuration);
        this.configuration.clear();
        this.configuration.putAll(configuration);
    }

    @Override
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IPeerModel[] peers;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((peers = this.getParentModel().getPeers()).length > 0) {
            try {
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Scanner.this.setThread(Thread.currentThread());
                    }
                });
                IPeerModel[] iPeerModelArray = peers;
                int n = peers.length;
                int n2 = 0;
                while (n2 < n) {
                    IPeerModel peer = iPeerModelArray[n2];
                    if (monitor.isCanceled() || this.isTerminated()) break;
                    ScannerRunnable runnable = new ScannerRunnable(this, peer);
                    Protocol.invokeLater((Runnable)runnable);
                    ++n2;
                }
                final IStatus result = monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Scanner.this.done(result);
                        Long delay = (Long)Scanner.this.getConfiguration().get("schedule");
                        if (delay != null) {
                            Scanner.this.schedule(delay);
                        }
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return peers.length > 0 ? ASYNC_FINISH : Status.OK_STATUS;
    }

    @Override
    public void terminate() {
        this.terminated.set(true);
    }

    @Override
    public final boolean isTerminated() {
        return this.terminated.get();
    }

    public boolean shouldRun() {
        return Platform.isRunning() && !this.getParentModel().isDisposed() && !this.isTerminated();
    }

    public boolean shouldSchedule() {
        return Platform.isRunning() && !this.getParentModel().isDisposed() && !this.isTerminated();
    }
}

