/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.commands.AbstractActionDelegate;
import org.eclipse.tcf.internal.debug.ui.model.ICastToType;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.ui.IWorkbenchWindow;

public class CastToTypeCommand
extends AbstractActionDelegate {
    protected void run() {
        final TCFNode node = this.getCastToTypeNode();
        if (node == null) {
            return;
        }
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        CastToTypeDialog dialog = new CastToTypeDialog(window.getShell(), node.getModel().getCastToType(node.getID()));
        if (dialog.open() != 0) {
            return;
        }
        final String new_type = dialog.getValue().trim();
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                node.getModel().setCastToType(node.getID(), new_type);
            }
        });
    }

    protected void selectionChanged() {
        this.getAction().setEnabled(this.getCastToTypeNode() != null);
    }

    private TCFNode getCastToTypeNode() {
        TCFNode node = this.getSelectedNode();
        if (node instanceof ICastToType) {
            if (node instanceof TCFNodeExpression && ((TCFNodeExpression)node).isEmpty()) {
                return null;
            }
            return node;
        }
        return null;
    }

    private class CastToTypeDialog
    extends InputDialog {
        public CastToTypeDialog(Shell shell, String initial_value) {
            super(shell, "Cast To Type", "Enter type name", initial_value, (IInputValidator)new CastToTypeInputValidator());
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setImage(ImageCache.getImage("icons/tcf.gif"));
        }
    }

    private class CastToTypeInputValidator
    implements IInputValidator {
        public String isValid(String new_text) {
            return null;
        }
    }
}

