/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.persistence;

import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.launch.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.persistence.PersistenceManager;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistenceDelegate;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractItemListXMLParser<ItemType>
extends DefaultHandler {
    private static final int IN_ITEMS_DEFINITION = 1;
    private static final int IN_ITEM_DEFINITION = 2;
    private SAXParser parser;
    private int parseState;
    private String lastData;
    private String lastType;
    private List<ItemType> items;
    private final String containerTag;
    private final String itemTag;
    public static final String ATTR_TYPE = "type";

    public AbstractItemListXMLParser(String tagName) {
        Assert.isNotNull((Object)tagName);
        this.containerTag = String.valueOf(tagName) + "s";
        this.itemTag = tagName;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        try {
            this.parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getClass().getName(), (Throwable)e);
            Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
        }
        catch (SAXException e) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getClass().getName(), (Throwable)e);
            Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
        }
    }

    public SAXParser getXMLReader() {
        return this.parser;
    }

    public void initXMLParser() {
        this.parseState = 0;
        this.lastData = null;
        this.lastType = null;
        this.items = null;
    }

    public void setItems(List<ItemType> items) {
        this.items = items;
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        block16: {
            if (this.containerTag.equalsIgnoreCase(name) && (this.parseState & 1) == 1) {
                this.parseState ^= 1;
            }
            if (this.itemTag.equalsIgnoreCase(name) && (this.parseState & 2) == 2) {
                this.parseState ^= 2;
                if (this.lastType != null && this.lastData != null) {
                    IPersistenceDelegate delegate;
                    Class clazz;
                    block15: {
                        block14: {
                            clazz = null;
                            try {
                                clazz = CoreBundleActivator.getContext().getBundle().loadClass(this.lastType);
                            }
                            catch (ClassNotFoundException e) {
                                if (!Platform.inDebugMode()) break block14;
                                Status status = new Status(2, CoreBundleActivator.getUniqueIdentifier(), "Launch framework internal error: " + e.getLocalizedMessage(), (Throwable)e);
                                Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                            }
                        }
                        if (clazz == null) {
                            String bundleId = this.lastType;
                            Bundle bundle = null;
                            while (bundleId != null && bundle == null) {
                                bundle = Platform.getBundle((String)bundleId);
                                if (bundle != null) continue;
                                int i = bundleId.lastIndexOf(46);
                                bundleId = i != -1 ? bundleId.substring(0, i) : null;
                            }
                            if (bundle != null) {
                                try {
                                    clazz = bundle.loadClass(this.lastType);
                                }
                                catch (ClassNotFoundException e) {
                                    if (!Platform.inDebugMode()) break block15;
                                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), "Launch framework internal error: " + e.getLocalizedMessage(), (Throwable)e);
                                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                                }
                            }
                        }
                    }
                    if (clazz != null && (delegate = PersistenceManager.getInstance().getDelegate((Object)clazz, (Object)this.lastData, false)) != null) {
                        try {
                            Object item = delegate.read(this.getReadClass(), (Object)this.lastData, null);
                            if (!this.items.contains(item)) {
                                this.items.add(item);
                            }
                        }
                        catch (IOException e) {
                            if (!Platform.inDebugMode()) break block16;
                            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), "Launch framework internal error: " + e.getLocalizedMessage(), (Throwable)e);
                            Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                        }
                    }
                }
            }
        }
    }

    protected abstract Class<?> getReadClass();

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.lastData = null;
        if (this.containerTag.equalsIgnoreCase(name)) {
            this.parseState |= 1;
        }
        if (this.itemTag.equalsIgnoreCase(name) && (this.parseState & 1) == 1) {
            this.parseState |= 2;
            this.lastType = attributes.getValue(ATTR_TYPE);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.lastData = this.lastData == null ? new String(ch, start, length).trim() : String.valueOf(this.lastData) + new String(ch, start, length).trim();
    }
}

