/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.persistence.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.runtime.extensions.AbstractExtensionPointManager;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.runtime.persistence.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.persistence.internal.PersistenceDelegateBinding;
import org.osgi.framework.Bundle;

public class PersistenceDelegateBindingExtensionPointManager
extends AbstractExtensionPointManager<PersistenceDelegateBinding> {
    PersistenceDelegateBindingExtensionPointManager() {
    }

    public static PersistenceDelegateBindingExtensionPointManager getInstance() {
        return LazyInstance.instance;
    }

    protected String getExtensionPointId() {
        return "org.eclipse.tcf.te.runtime.persistence.bindings";
    }

    protected String getConfigurationElementName() {
        return "binding";
    }

    protected ExecutableExtensionProxy<PersistenceDelegateBinding> doCreateExtensionProxy(IConfigurationElement element) throws CoreException {
        return new ExecutableExtensionProxy<PersistenceDelegateBinding>(element){

            public PersistenceDelegateBinding newInstance() {
                PersistenceDelegateBinding instance = new PersistenceDelegateBinding();
                try {
                    instance.setInitializationData(this.getConfigurationElement(), null, null);
                }
                catch (CoreException e) {
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                }
                return instance;
            }
        };
    }

    public PersistenceDelegateBinding[] getApplicableBindings(Object context, Object container) {
        ArrayList<PersistenceDelegateBinding> applicable = new ArrayList<PersistenceDelegateBinding>();
        PersistenceDelegateBinding[] persistenceDelegateBindingArray = this.getBindings();
        int n = persistenceDelegateBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isApplicable;
            PersistenceDelegateBinding binding = persistenceDelegateBindingArray[n2];
            Expression enablement = binding.getEnablement();
            boolean bl = isApplicable = enablement == null;
            if (enablement != null) {
                if (context != null) {
                    EvaluationContext evalContext = new EvaluationContext(null, context);
                    evalContext.addVariable("context", context);
                    if (context instanceof Class) {
                        evalContext.addVariable("contextClass", (Object)((Class)context).getName());
                    }
                    evalContext.addVariable("container", container);
                    if (container instanceof Class) {
                        evalContext.addVariable("containerClass", (Object)((Class)container).getName());
                    }
                    evalContext.setAllowPluginActivation(true);
                    try {
                        isApplicable = enablement.evaluate((IEvaluationContext)evalContext).equals(EvaluationResult.TRUE);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                        Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                    }
                } else {
                    isApplicable = false;
                }
            }
            if (isApplicable) {
                applicable.add(binding);
            }
            ++n2;
        }
        return applicable.toArray(new PersistenceDelegateBinding[applicable.size()]);
    }

    public PersistenceDelegateBinding[] getBindings() {
        ArrayList<PersistenceDelegateBinding> contributions = new ArrayList<PersistenceDelegateBinding>();
        Collection persistenceDelegateBindings = this.getExtensions().values();
        for (ExecutableExtensionProxy persistenceDelegateBinding : persistenceDelegateBindings) {
            PersistenceDelegateBinding instance = (PersistenceDelegateBinding)((Object)persistenceDelegateBinding.getInstance());
            if (instance == null || contributions.contains((Object)instance)) continue;
            contributions.add(instance);
        }
        return contributions.toArray(new PersistenceDelegateBinding[contributions.size()]);
    }

    public PersistenceDelegateBinding getBinding(String id) {
        PersistenceDelegateBinding contribution = null;
        if (this.getExtensions().containsKey(id)) {
            ExecutableExtensionProxy proxy = (ExecutableExtensionProxy)this.getExtensions().get(id);
            contribution = (PersistenceDelegateBinding)((Object)proxy.getInstance());
        }
        return contribution;
    }

    private static class LazyInstance {
        public static PersistenceDelegateBindingExtensionPointManager instance = new PersistenceDelegateBindingExtensionPointManager();

        private LazyInstance() {
        }
    }
}

