/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.model;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.tcf.te.core.interfaces.IViewerInput;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModelProvider;

public abstract class AbstractTreeNode
extends PlatformObject
implements IPeerModelProvider {
    private final UUID uniqueId = UUID.randomUUID();
    public String name = null;
    public String type = null;
    public IPeerModel peerNode = null;
    public boolean childrenQueried = false;
    public boolean childrenQueryRunning = false;
    protected AbstractTreeNode parent = null;
    protected List<AbstractTreeNode> children = Collections.synchronizedList(new ArrayList());

    public final int hashCode() {
        return this.uniqueId.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractTreeNode) {
            return this.uniqueId.equals(((AbstractTreeNode)((Object)obj)).uniqueId);
        }
        return super.equals(obj);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName());
        buffer.append(": name=" + (this.name != null ? this.name : super.toString()));
        buffer.append(", UUID=" + this.uniqueId.toString());
        return buffer.toString();
    }

    public IPeerModel getPeerModel() {
        return this.peerNode;
    }

    public void queryDone() {
        this.childrenQueryRunning = false;
        this.childrenQueried = true;
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "query_done", Boolean.FALSE, Boolean.TRUE);
        this.firePropertyChange(event);
    }

    public void queryStarted() {
        this.childrenQueryRunning = true;
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "query_started", Boolean.FALSE, Boolean.TRUE);
        this.firePropertyChange(event);
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        if (this.peerNode != null) {
            IViewerInput viewerInput = (IViewerInput)this.peerNode.getAdapter(IViewerInput.class);
            viewerInput.firePropertyChange(event);
        } else if (this.parent != null) {
            this.parent.firePropertyChange(event);
        }
    }

    public void addChidren(List<? extends AbstractTreeNode> nodes) {
        this.children.addAll(nodes);
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "addChildren", null, null);
        this.firePropertyChange(event);
    }

    public void removeChildren(List<? extends AbstractTreeNode> nodes) {
        this.children.removeAll(nodes);
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "removeChildren", null, null);
        this.firePropertyChange(event);
    }

    public void addChild(AbstractTreeNode node) {
        this.children.add(node);
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "addChild", null, null);
        this.firePropertyChange(event);
    }

    public void removeChild(AbstractTreeNode node) {
        this.children.remove((Object)node);
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "removeChild", null, null);
        this.firePropertyChange(event);
    }

    public void clearChildren() {
        this.children.clear();
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "clearChildren", null, null);
        this.firePropertyChange(event);
    }

    public boolean isAncestorOf(AbstractTreeNode node) {
        if (node == null) {
            return false;
        }
        if (node.parent == this) {
            return true;
        }
        return this.isAncestorOf(node.parent);
    }

    public AbstractTreeNode getParent() {
        return this.parent;
    }

    public void setParent(AbstractTreeNode parent) {
        this.parent = parent;
    }

    public void refresh() {
        this.refresh(null);
    }

    public void refresh(ICallback callback) {
        this.queryStarted();
        Tcf.getChannelManager().openChannel(this.peerNode.getPeer(), null, this.doCreateRefreshDoneOpenChannel(callback));
    }

    protected abstract IChannelManager.DoneOpenChannel doCreateRefreshDoneOpenChannel(ICallback var1);

    public void queryChildren() {
        this.queryChildren(null);
    }

    public void queryChildren(ICallback callback) {
        this.queryStarted();
        Tcf.getChannelManager().openChannel(this.peerNode.getPeer(), null, this.doCreateQueryDoneOpenChannel(callback));
    }

    protected abstract IChannelManager.DoneOpenChannel doCreateQueryDoneOpenChannel(ICallback var1);

    public abstract boolean isSystemRoot();

    public List<? extends AbstractTreeNode> getChildren() {
        return new ArrayList<AbstractTreeNode>(this.children);
    }
}

