/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.ssh.controls;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.terminals.panels.AbstractConfigurationPanel;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.ssh.SshConnector;
import org.eclipse.tm.internal.terminal.ssh.SshSettings;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SshWizardConfigurationPanel
extends AbstractConfigurationPanel
implements IDataExchangeNode {
    private SshSettings sshSettings;
    private ISettingsPage sshSettingsPage;

    public SshWizardConfigurationPanel(BaseDialogPageControl parentControl) {
        super(parentControl);
    }

    public void setupPanel(Composite parent, FormToolkit toolkit) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, true);
        panel.setLayoutData((Object)data);
        if (this.isWithoutSelection()) {
            this.createHostsUI(panel);
        }
        SshConnector conn = new SshConnector();
        this.sshSettings = (SshSettings)conn.getSshSettings();
        this.sshSettings.setHost(this.getSelectionHost());
        this.sshSettings.setUser(this.getDefaultUser());
        this.sshSettingsPage = conn.makeSettingsPage();
        this.sshSettingsPage.createControl(panel);
        this.setControl(panel);
    }

    public boolean dataChanged(IPropertiesContainer data, TypedEvent e) {
        return false;
    }

    public void setupData(IPropertiesContainer data) {
    }

    private String getDefaultUser() {
        return System.getProperty("user.name");
    }

    public void extractData(IPropertiesContainer data) {
        data.setProperty("tm.terminal.connector.id", (Object)"org.eclipse.tm.internal.terminal.ssh.SshConnector");
        data.setProperty("connector.type.id", (Object)"org.eclipse.tcf.te.ui.terminals.type.ssh");
        this.sshSettingsPage.saveSettings();
        data.setProperty("ip.host", (Object)this.sshSettings.getHost());
        data.setProperty("ip.port", this.sshSettings.getPort());
        data.setProperty("timeout", this.sshSettings.getTimeout());
        data.setProperty("ssh.keep_alive", this.sshSettings.getKeepalive());
        data.setProperty("ssh.password", (Object)this.sshSettings.getPassword());
        data.setProperty("ssh.user", (Object)this.sshSettings.getUser());
    }

    protected void fillSettingsForHost(String host) {
        if (host != null && host.length() != 0) {
            if (this.hostSettingsMap.containsKey(host)) {
                String password;
                Map hostSettings = (Map)this.hostSettingsMap.get(host);
                if (hostSettings.get("ip.host") != null) {
                    this.sshSettings.setHost((String)hostSettings.get("ip.host"));
                }
                if (hostSettings.get("ip.port") != null) {
                    this.sshSettings.setPort((String)hostSettings.get("ip.port"));
                }
                if (hostSettings.get("timeout") != null) {
                    this.sshSettings.setTimeout((String)hostSettings.get("timeout"));
                }
                if (hostSettings.get("ssh.keep_alive") != null) {
                    this.sshSettings.setKeepalive((String)hostSettings.get("ssh.keep_alive"));
                }
                if (hostSettings.get("ssh.user") != null) {
                    this.sshSettings.setUser((String)hostSettings.get("ssh.user"));
                }
                if ((password = this.accessSecurePassword(this.sshSettings.getHost())) != null) {
                    this.sshSettings.setPassword(password);
                }
            } else {
                this.sshSettings.setHost(this.getSelectionHost());
                this.sshSettings.setUser(this.getDefaultUser());
            }
            this.sshSettingsPage.loadSettings();
        }
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        this.saveSettingsForHost(true);
        super.doSaveWidgetValues(settings, idPrefix);
    }

    protected void saveSettingsForHost(boolean add) {
        String host = this.getHostFromSettings();
        if (host != null && host.length() != 0) {
            if (this.hostSettingsMap.containsKey(host)) {
                Map hostSettings = (Map)this.hostSettingsMap.get(host);
                hostSettings.put("ip.host", this.sshSettings.getHost());
                hostSettings.put("ip.port", Integer.toString(this.sshSettings.getPort()));
                hostSettings.put("timeout", Integer.toString(this.sshSettings.getTimeout()));
                hostSettings.put("ssh.keep_alive", Integer.toString(this.sshSettings.getKeepalive()));
                hostSettings.put("ssh.user", this.sshSettings.getUser());
                if (this.sshSettings.getPassword() != null && this.sshSettings.getPassword().length() != 0) {
                    this.saveSecurePassword(host, this.sshSettings.getPassword());
                }
            } else if (add) {
                HashMap<String, String> hostSettings = new HashMap<String, String>();
                hostSettings.put("ip.host", this.sshSettings.getHost());
                hostSettings.put("ip.port", Integer.toString(this.sshSettings.getPort()));
                hostSettings.put("timeout", Integer.toString(this.sshSettings.getTimeout()));
                hostSettings.put("ssh.keep_alive", Integer.toString(this.sshSettings.getKeepalive()));
                hostSettings.put("ssh.user", this.sshSettings.getUser());
                this.hostSettingsMap.put(host, hostSettings);
                if (this.sshSettings.getPassword() != null && this.sshSettings.getPassword().length() != 0) {
                    this.saveSecurePassword(host, this.sshSettings.getPassword());
                }
            }
        }
    }

    private void saveSecurePassword(String host, String password) {
        String nodeKey;
        ISecurePreferences node;
        Assert.isNotNull((Object)host);
        Assert.isNotNull((Object)password);
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        if (preferences != null && (node = preferences.node(nodeKey = "/Target Explorer SSH Password/" + host)) != null) {
            try {
                node.put("password", password, true);
            }
            catch (StorageException storageException) {}
        }
    }

    private String accessSecurePassword(String host) {
        String nodeKey;
        ISecurePreferences node;
        Assert.isNotNull((Object)host);
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        if (preferences != null && (node = preferences.node(nodeKey = "/Target Explorer SSH Password/" + host)) != null) {
            String password = null;
            try {
                password = node.get("password", null);
            }
            catch (StorageException storageException) {}
            return password;
        }
        return null;
    }

    protected void removeSecurePassword(String host) {
        String nodeKey;
        ISecurePreferences node;
        Assert.isNotNull((Object)host);
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        if (preferences != null && (node = preferences.node(nodeKey = "/Target Explorer SSH Password/" + host)) != null) {
            node.remove("password");
        }
    }

    public boolean isValid() {
        return this.sshSettingsPage.validateSettings();
    }

    protected String getHostFromSettings() {
        this.sshSettingsPage.saveSettings();
        return this.sshSettings.getHost();
    }
}

