/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.launch;

import java.io.File;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.tcf.internal.debug.launch.TCFSourceLookupParticipant;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.services.ILineNumbers;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;

public class TCFSourceLookupDirector
extends AbstractSourceLookupDirector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object lookup(final TCFLaunch launch, final String ctx, Object element) {
        if (element instanceof ILineNumbers.CodeArea) {
            element = TCFSourceLookupParticipant.toFileName((ILineNumbers.CodeArea)element);
        }
        Object source_element = null;
        ISourceLocator locator = launch.getSourceLocator();
        if (locator instanceof ISourceLookupDirector) {
            source_element = ((ISourceLookupDirector)locator).getSourceElement(element);
        } else if (element instanceof IStackFrame) {
            source_element = locator.getSourceElement((IStackFrame)element);
        }
        if (source_element == null && element instanceof String) {
            IPath path;
            Map<String, IStorage> map;
            String str;
            String key = str = (String)element;
            if (ctx != null) {
                key = String.valueOf(ctx) + "::" + str;
            }
            Map<String, IStorage> map2 = map = launch.getTargetPathMappingCache();
            synchronized (map2) {
                if (map.containsKey(str)) {
                    return map.get(key);
                }
            }
            IStorage storage = (IStorage)new TCFTask<IStorage>(launch.getChannel()){

                public void run() {
                    block9: {
                        TCFDataCache<IPathMap.PathMapRule[]> cache = launch.getTargetPathMap();
                        if (cache == null) break block9;
                        if (!cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        IPathMap.PathMapRule[] data = (IPathMap.PathMapRule[])cache.getData();
                        if (data == null) break block9;
                        IPathMap.PathMapRule[] pathMapRuleArray = data;
                        int n = data.length;
                        int n2 = 0;
                        while (n2 < n) {
                            block11: {
                                File file;
                                String fnm;
                                IPathMap.PathMapRule r;
                                block10: {
                                    TCFDataCache<String[]> q_cache;
                                    r = pathMapRuleArray[n2];
                                    String query = r.getContextQuery();
                                    if (query == null || query.length() <= 0 || query.equals("*")) break block10;
                                    if (ctx == null || (q_cache = launch.getContextQuery(query)) == null) break block11;
                                    if (!q_cache.validate((Runnable)((Object)this))) {
                                        return;
                                    }
                                    String[] q_data = (String[])q_cache.getData();
                                    if (q_data == null) break block11;
                                    boolean ok = false;
                                    String[] stringArray = q_data;
                                    int n3 = q_data.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        String id = stringArray[n4];
                                        if (ctx.equals(id)) {
                                            ok = true;
                                        }
                                        ++n4;
                                    }
                                    if (!ok) break block11;
                                }
                                if ((fnm = TCFSourceLookupParticipant.toFileName(r, str)) != null && (file = new File(fnm)).isAbsolute() && file.exists() && file.isFile()) {
                                    this.done(new LocalFileStorage(file));
                                    return;
                                }
                            }
                            ++n2;
                        }
                    }
                    this.done(null);
                }
            }.getE();
            if (storage != null && (path = storage.getFullPath()) != null) {
                URI uri = URIUtil.toURI((IPath)path);
                IFile[] arr = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
                if (arr != null && arr.length > 0) {
                    IFile[] iFileArray = arr;
                    int n = arr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile resource = iFileArray[n2];
                        if (resource.isAccessible()) {
                            storage = resource;
                            break;
                        }
                        ++n2;
                    }
                }
            }
            Map<String, IStorage> map3 = map;
            synchronized (map3) {
                map.put(key, storage);
            }
            source_element = storage;
        }
        return source_element;
    }

    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new TCFSourceLookupParticipant()});
    }
}

